/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.applet;

import com.jcraft.jzlib.ZStreamException;
import com.planet_ink.siplet.support.TelnetFilter;
import java.applet.Applet;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;

public class Siplet
extends Applet {
    public static final boolean debugDataOut = false;
    public static final long serialVersionUID = 7L;
    public static final float VERSION_MAJOR = 2.1f;
    public static final long VERSION_MINOR = 0L;
    protected StringBuffer buf = new StringBuffer("");
    protected String lastURL = "coffeemud.net";
    protected int lastPort = 23;
    protected Socket sock = null;
    protected InputStream rawin = null;
    protected BufferedReader[] in;
    protected DataOutputStream out;
    protected boolean connected = false;
    protected TelnetFilter Telnet = new TelnetFilter(this);
    protected StringBuffer buffer;
    protected int sillyCounter = 0;

    public void setFeatures(boolean bl, MSPStatus mSPStatus, boolean bl2) {
        this.Telnet.setNeverMCCPSupport(!bl2);
        this.Telnet.setNeverMXPSupport(!bl);
        this.Telnet.setNeverMSPSupport(mSPStatus);
    }

    @Override
    public void init() {
        this.buffer = new StringBuffer();
    }

    public String info() {
        return "Siplet V2.1.0 (C)2005-2014 Bo Zimmerman";
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }

    public Siplet create() {
        return new Siplet();
    }

    public void addItem(String string) {
        this.buffer.append(string);
    }

    @Override
    public void paint(Graphics graphics) {
    }

    public boolean connectToURL() {
        return this.connectToURL(this.lastURL, this.lastPort);
    }

    public boolean connectToURL(String string, int n) {
        this.connected = false;
        if (this.sock != null) {
            this.disconnectFromURL();
        }
        try {
            this.lastURL = string;
            this.lastPort = n;
            this.sock = new Socket(InetAddress.getByName(string), n);
            Thread.sleep(100L);
            this.rawin = this.sock.getInputStream();
            this.in = new BufferedReader[1];
            this.in[0] = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), "iso-8859-1"));
            this.out = new DataOutputStream(this.sock.getOutputStream());
            this.Telnet = new TelnetFilter(this);
            this.connected = true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean connectToURL(String string, int n, Socket socket) {
        this.connected = false;
        if (this.sock != null) {
            this.disconnectFromURL();
        }
        try {
            this.lastURL = string;
            this.lastPort = n;
            this.sock = socket;
            this.rawin = socket.getInputStream();
            this.in = new BufferedReader[1];
            this.in[0] = new BufferedReader(new InputStreamReader(socket.getInputStream(), "iso-8859-1"));
            this.out = new DataOutputStream(socket.getOutputStream());
            this.Telnet = new TelnetFilter(this);
            this.connected = true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public void disconnectFromURL() {
        this.connected = false;
        try {
            if (this.out != null) {
                this.out.write(new byte[]{-1, -3, 18});
                this.out.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.in != null && this.in[0] != null) {
                this.in[0].close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.in = null;
        this.out = null;
        this.sock = null;
    }

    public void sendData(String string) {
        if (this.connected) {
            try {
                if (this.sock.isClosed()) {
                    this.disconnectFromURL();
                } else if (!this.sock.isConnected()) {
                    this.disconnectFromURL();
                } else {
                    byte[] byArray = this.Telnet.peruseInput(string);
                    if (byArray != null) {
                        this.out.write(byArray);
                        if (byArray.length == 0 || byArray[byArray.length - 1] != 13 && byArray[byArray.length - 1] != 10) {
                            this.out.writeBytes("\n");
                        }
                        this.out.flush();
                    }
                }
            }
            catch (IOException iOException) {
                this.disconnectFromURL();
            }
        }
    }

    public String getJScriptCommands() {
        return this.Telnet.getEnquedJScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURLData() {
        StringBuffer stringBuffer = this.buf;
        synchronized (stringBuffer) {
            String string = this.Telnet.getEnquedResponses();
            if (string.length() > 0) {
                this.sendData(string);
            }
            StringBuilder stringBuilder = new StringBuilder("");
            if (this.Telnet.MSDPsupport()) {
                stringBuilder.append(this.Telnet.getMsdpHtml());
            }
            if (this.Telnet.GMCPsupport()) {
                stringBuilder.append(this.Telnet.getGmcpHtml());
            }
            int n = this.Telnet.HTMLFilter(this.buf);
            if (this.buf.length() == 0) {
                return stringBuilder.toString();
            }
            if (n < 0) {
                n = this.buf.length();
            }
            if (n == 0) {
                return stringBuilder.toString();
            }
            if (this.Telnet.isUIonHold()) {
                return stringBuilder.toString();
            }
            if (n < this.buf.length()) {
                stringBuilder.append(this.buf.substring(0, n));
                this.buf.delete(0, n);
            } else {
                stringBuilder.append(this.buf.toString());
                this.buf.setLength(0);
            }
            return stringBuilder.toString();
        }
    }

    public boolean isConnectedToURL() {
        return this.connected;
    }

    public void readURLData() {
        try {
            while (this.connected && this.in[0].ready() && !this.sock.isClosed() && this.sock.isConnected()) {
                try {
                    this.Telnet.TelnetRead(this.buf, this.rawin, this.in);
                }
                catch (InterruptedIOException interruptedIOException) {
                    this.disconnectFromURL();
                    return;
                }
                catch (Exception exception) {
                    if (exception instanceof ZStreamException) {
                        this.disconnectFromURL();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        this.connectToURL();
                        continue;
                    }
                    this.disconnectFromURL();
                    return;
                }
            }
            if (this.sock.isClosed()) {
                this.disconnectFromURL();
            } else if (!this.sock.isConnected()) {
                this.disconnectFromURL();
            } else if (this.buf.length() > 0) {
                this.Telnet.TelenetFilter(this.buf, this.out, this.rawin, this.in);
            }
        }
        catch (Exception exception) {
            this.disconnectFromURL();
            return;
        }
    }

    public static enum MSPStatus {
        Disabled,
        Internal,
        External;

    }
}

