/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.support;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public class MiniJSON {
    public static final Object NULL = new Object();

    public static String toJSONString(String string) {
        StringBuilder stringBuilder = new StringBuilder("");
        block8: for (char c : string.toCharArray()) {
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    stringBuilder.append('\\').append(c);
                    continue block8;
                }
                case '\b': {
                    stringBuilder.append('\\').append('b');
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append('\\').append('f');
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append('\\').append('r');
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append('\\').append('t');
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private Object parseNumber(char[] cArray, int[] nArray) throws MJSONException {
        int n = nArray[0];
        NumberParseState numberParseState = NumberParseState.INITIAL;
        while (nArray[0] < cArray.length) {
            char c = cArray[nArray[0]];
            switch (numberParseState) {
                case INITIAL: {
                    if (c == '0') {
                        numberParseState = NumberParseState.NEEDDOT;
                        break;
                    }
                    if (c == '-') {
                        numberParseState = NumberParseState.NEEDN0DIGIT;
                        break;
                    }
                    if (Character.isDigit(c)) {
                        numberParseState = NumberParseState.HAVEDIGIT;
                        break;
                    }
                    throw new MJSONException("Expected digit at " + nArray[0]);
                }
                case NEEDN0DIGIT: {
                    if (c == '0') {
                        throw new MJSONException("Expected digit at " + nArray[0]);
                    }
                    if (Character.isDigit(c)) {
                        numberParseState = NumberParseState.HAVEDIGIT;
                        break;
                    }
                    throw new MJSONException("Expected digit at " + nArray[0]);
                }
                case HAVEDIGIT: {
                    if (c == '.') {
                        numberParseState = NumberParseState.NEEDDOTDIGIT;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        numberParseState = NumberParseState.HAVEE;
                        break;
                    }
                    if (Character.isDigit(c)) {
                        numberParseState = NumberParseState.HAVEDIGIT;
                        break;
                    }
                    nArray[0] = nArray[0] - 1;
                    return Long.valueOf(new String(cArray, n, nArray[0] - n + 1));
                }
                case NEEDDOT: {
                    if (c == '.') {
                        numberParseState = NumberParseState.NEEDDOTDIGIT;
                        break;
                    }
                    nArray[0] = nArray[0] - 1;
                    return Long.valueOf(new String(cArray, n, nArray[0] - n + 1));
                }
                case NEEDDOTDIGIT: {
                    if (Character.isDigit(c)) {
                        numberParseState = NumberParseState.HAVEDOTDIGIT;
                        break;
                    }
                    throw new MJSONException("Expected digit at " + nArray[0]);
                }
                case HAVEDOTDIGIT: {
                    if (Character.isDigit(c)) {
                        numberParseState = NumberParseState.HAVEDOTDIGIT;
                        break;
                    }
                    if (c == 'e' || c == 'E') {
                        numberParseState = NumberParseState.HAVEE;
                        break;
                    }
                    nArray[0] = nArray[0] - 1;
                    return Double.valueOf(new String(cArray, n, nArray[0] - n + 1));
                }
                case HAVEE: {
                    if (c == '0') {
                        throw new MJSONException("Expected non-zero digit at " + nArray[0]);
                    }
                    if (Character.isDigit(c) || c == '+' || c == '-') {
                        numberParseState = NumberParseState.HAVEEDIGIT;
                        break;
                    }
                    throw new MJSONException("Expected +- or non-zero digit at " + nArray[0]);
                }
                case HAVEEDIGIT: {
                    if (Character.isDigit(c)) break;
                    nArray[0] = nArray[0] - 1;
                    return new BigDecimal(new String(cArray, n, nArray[0] - n + 1)).doubleValue();
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        throw new MJSONException("Unexpected end of number at" + nArray[0]);
    }

    private byte getByteFromHex(char[] cArray, int n) throws MJSONException {
        char c = cArray[n];
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(10 + (c - 97));
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(10 + (c - 65));
        }
        throw new MJSONException("Illegal hex digit at " + n);
    }

    private String parseString(char[] cArray, int[] nArray) throws MJSONException {
        StringBuilder stringBuilder = new StringBuilder("");
        if (cArray[nArray[0]] != '\"') {
            throw new MJSONException("Expectged quote at: " + cArray[nArray[0]]);
        }
        nArray[0] = nArray[0] + 1;
        while (nArray[0] < cArray.length) {
            block16: {
                char c;
                block17: {
                    c = cArray[nArray[0]];
                    if (c == '\"') {
                        return stringBuilder.toString();
                    }
                    if (c != '\\') break block17;
                    if (nArray[0] == cArray.length - 1) {
                        throw new MJSONException("Unfinished escape");
                    }
                    nArray[0] = nArray[0] + 1;
                    switch (cArray[nArray[0]]) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            stringBuilder.append(cArray[nArray[0]]);
                            break block16;
                        }
                        case 'b': {
                            stringBuilder.append('\b');
                            break block16;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            break block16;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            break block16;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            break block16;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            break block16;
                        }
                        case 'u': {
                            if (nArray[0] >= cArray.length - 5) {
                                throw new MJSONException("Unfinished unicode escape at " + nArray[0]);
                            }
                            byte[] byArray = new byte[4];
                            nArray[0] = nArray[0] + 1;
                            byArray[0] = this.getByteFromHex(cArray, nArray[0]);
                            nArray[0] = nArray[0] + 1;
                            byArray[1] = this.getByteFromHex(cArray, nArray[0]);
                            nArray[0] = nArray[0] + 1;
                            byArray[2] = this.getByteFromHex(cArray, nArray[0]);
                            nArray[0] = nArray[0] + 1;
                            byArray[3] = this.getByteFromHex(cArray, nArray[0]);
                            try {
                                stringBuilder.append(new String(byArray, "Cp1251"));
                                break block16;
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                throw new MJSONException("Illegal character at" + nArray[0], unsupportedEncodingException);
                            }
                        }
                        default: {
                            throw new MJSONException("Illegal escape character: " + cArray[nArray[0]]);
                        }
                    }
                }
                stringBuilder.append(c);
            }
            nArray[0] = nArray[0] + 1;
        }
        throw new MJSONException("Unfinished string at " + nArray[0]);
    }

    private Object[] parseArray(char[] cArray, int[] nArray) throws MJSONException {
        ArrayParseState arrayParseState = ArrayParseState.INITIAL;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (nArray[0] < cArray.length) {
            char c = cArray[nArray[0]];
            if (!Character.isWhitespace(c)) {
                switch (arrayParseState) {
                    case INITIAL: {
                        if (c == '[') {
                            arrayParseState = ArrayParseState.NEEDOBJECT;
                            break;
                        }
                        throw new MJSONException("Expected String at " + nArray[0]);
                    }
                    case EXPECTOBJECT: {
                        arrayList.add(this.parseElement(cArray, nArray));
                        arrayParseState = ArrayParseState.GOTOBJECT;
                        break;
                    }
                    case NEEDOBJECT: {
                        if (c == ']') {
                            return arrayList.toArray(new Object[0]);
                        }
                        arrayList.add(this.parseElement(cArray, nArray));
                        arrayParseState = ArrayParseState.GOTOBJECT;
                        break;
                    }
                    case GOTOBJECT: {
                        if (c == ']') {
                            return arrayList.toArray(new Object[0]);
                        }
                        if (c == ',') {
                            arrayParseState = ArrayParseState.EXPECTOBJECT;
                            break;
                        }
                        throw new MJSONException("Expected ] or , at " + nArray[0]);
                    }
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        throw new MJSONException("Expected ] at " + nArray[0]);
    }

    private Object parseElement(char[] cArray, int[] nArray) throws MJSONException {
        switch (cArray[nArray[0]]) {
            case '\"': {
                return this.parseString(cArray, nArray);
            }
            case '[': {
                return this.parseArray(cArray, nArray);
            }
            case '{': {
                return this.parseObject(cArray, nArray);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseNumber(cArray, nArray);
            }
            case 't': {
                if (nArray[0] < cArray.length - 5 && new String(cArray, nArray[0], 4).equals("true")) {
                    nArray[0] = nArray[0] + 3;
                    return Boolean.TRUE;
                }
                throw new MJSONException("Invalid true at " + nArray[0]);
            }
            case 'f': {
                if (nArray[0] < cArray.length - 6 && new String(cArray, nArray[0], 5).equals("false")) {
                    nArray[0] = nArray[0] + 4;
                    return Boolean.FALSE;
                }
                throw new MJSONException("Invalid false at " + nArray[0]);
            }
            case 'n': {
                if (nArray[0] < cArray.length - 5 && new String(cArray, nArray[0], 4).equals("null")) {
                    nArray[0] = nArray[0] + 3;
                    return NULL;
                }
                throw new MJSONException("Invalid null at " + nArray[0]);
            }
        }
        throw new MJSONException("Unknown character at " + nArray[0]);
    }

    private JSONObject parseObject(char[] cArray, int[] nArray) throws MJSONException {
        JSONObject jSONObject = new JSONObject();
        String string = null;
        ObjectParseState objectParseState = ObjectParseState.INITIAL;
        while (nArray[0] < cArray.length) {
            char c = cArray[nArray[0]];
            if (!Character.isWhitespace(c)) {
                switch (objectParseState) {
                    case INITIAL: {
                        if (c == '{') {
                            objectParseState = ObjectParseState.NEEDKEY;
                            break;
                        }
                        throw new MJSONException("Expected Key/String at " + nArray[0]);
                    }
                    case NEEDKEY: {
                        if (c == '\"') {
                            string = this.parseString(cArray, nArray);
                            objectParseState = ObjectParseState.GOTKEY;
                            break;
                        }
                        if (c == '}') {
                            return jSONObject;
                        }
                        throw new MJSONException("Expected Key/String at " + nArray[0]);
                    }
                    case GOTKEY: {
                        if (c == ':') {
                            objectParseState = ObjectParseState.NEEDOBJECT;
                            break;
                        }
                        throw new MJSONException("Expected Colon at " + nArray[0]);
                    }
                    case NEEDOBJECT: {
                        jSONObject.put(string, this.parseElement(cArray, nArray));
                        objectParseState = ObjectParseState.GOTOBJECT;
                        break;
                    }
                    case GOTOBJECT: {
                        if (c == ',') {
                            objectParseState = ObjectParseState.NEEDKEY;
                            break;
                        }
                        if (c == '}') {
                            return jSONObject;
                        }
                        throw new MJSONException("Expected } or , at " + nArray[0]);
                    }
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        throw new MJSONException("Expected } at " + nArray[0]);
    }

    public JSONObject parseObject(String string) throws MJSONException {
        try {
            return this.parseObject(string.toCharArray(), new int[]{0});
        }
        catch (MJSONException mJSONException) {
            throw mJSONException;
        }
        catch (Exception exception) {
            throw new MJSONException("Internal error", exception);
        }
    }

    public static class JSONObject
    extends TreeMap<String, Object> {
        private static final long serialVersionUID = 8390676973120915175L;

        private Object getCheckedObject(String string) throws MJSONException {
            if (!this.containsKey(string)) {
                throw new MJSONException("Key '" + string + "' not found");
            }
            return this.get(string);
        }

        public JSONObject getCheckedJSONObject(String string) throws MJSONException {
            Object object = this.getCheckedObject(string);
            if (!(object instanceof JSONObject)) {
                throw new MJSONException("Key '" + string + "' is not a JSON object");
            }
            return (JSONObject)object;
        }

        public Object[] getCheckedArray(String string) throws MJSONException {
            Object object = this.getCheckedObject(string);
            if (!(object instanceof Object[])) {
                throw new MJSONException("Key '" + string + "' is not an array");
            }
            return (Object[])object;
        }

        public String getCheckedString(String string) throws MJSONException {
            Object object = this.getCheckedObject(string);
            if (!(object instanceof String)) {
                throw new MJSONException("Key '" + string + "' is not a String");
            }
            return (String)object;
        }

        public Long getCheckedLong(String string) throws MJSONException {
            Object object = this.getCheckedObject(string);
            if (!(object instanceof Long)) {
                throw new MJSONException("Key '" + string + "' is not a long");
            }
            return (Long)object;
        }

        public Double getCheckedDouble(String string) throws MJSONException {
            Object object = this.getCheckedObject(string);
            if (!(object instanceof Double)) {
                throw new MJSONException("Key '" + string + "' is not a double");
            }
            return (Double)object;
        }

        public Boolean getCheckedBoolean(String string) throws MJSONException {
            Object object = this.getCheckedObject(string);
            if (!(object instanceof Boolean)) {
                throw new MJSONException("Key '" + string + "' is not a boolean");
            }
            return (Boolean)object;
        }

        public double getCheckedNumber(String string) throws MJSONException {
            Object object = this.getCheckedObject(string);
            if (object instanceof Double) {
                return (Double)object;
            }
            if (object instanceof Long) {
                return ((Long)object).doubleValue();
            }
            throw new MJSONException("Key '" + string + "' is not a number");
        }

        public boolean isCheckedNULL(String string) throws MJSONException {
            Object object = this.getCheckedObject(string);
            return object == NULL;
        }

        public void appendJSONString(StringBuilder stringBuilder, Object object) {
            if (object instanceof String) {
                stringBuilder.append("\"").append(MiniJSON.toJSONString((String)object)).append("\"");
            } else if (object == NULL) {
                stringBuilder.append("null");
            } else if (object instanceof Object[]) {
                stringBuilder.append("[");
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(",");
                    }
                    this.appendJSONString(stringBuilder, objectArray[i]);
                }
                stringBuilder.append("]");
            } else if (object != null) {
                stringBuilder.append(object.toString());
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("");
            stringBuilder.append("{");
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuilder.append("\"").append(MiniJSON.toJSONString(string)).append("\":");
                Object v = this.get(string);
                this.appendJSONString(stringBuilder, v);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    public static class MJSONException
    extends Exception {
        private static final long serialVersionUID = -2651922052891126260L;

        public MJSONException(String string) {
            super(string);
        }

        public MJSONException(String string, Exception exception) {
            super(string, exception);
        }
    }

    private static enum ArrayParseState {
        INITIAL,
        EXPECTOBJECT,
        NEEDOBJECT,
        GOTOBJECT;

    }

    private static enum NumberParseState {
        INITIAL,
        NEEDN0DIGIT,
        HAVEDIGIT,
        NEEDDOT,
        NEEDDOTDIGIT,
        HAVEDOTDIGIT,
        HAVEE,
        HAVEEDIGIT;

    }

    private static enum ObjectParseState {
        INITIAL,
        NEEDKEY,
        GOTKEY,
        NEEDOBJECT,
        GOTOBJECT;

    }
}

