/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.graph.ChartConfiguration;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring.EventColorType;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring.EventTypeColor;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring.GradientColor;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring.IEventColor;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring.ValueColor;
import com.jrockit.mc.ui.misc.MCColor;
import java.awt.Color;
import java.util.Set;

public final class EventColorFactory {
    private static final MCColor MISSING_COLOR = new MCColor(Color.BLACK);

    public static IEventColor create(IServiceLocator serviceLocator, ChartConfiguration config) {
        EventTypeAcceptor eta = new EventTypeAcceptor(serviceLocator, config.getEventTypes());
        Set<IEventType> types = eta.getAcceptedSet();
        if (config.getEventColorType() == EventColorType.GRADIENT_COLOR) {
            return new GradientColor(config.getGradientBeginValue(), config.getGradientBeginColor().getAWTColor(), config.getGradientEndValue(), config.getGradientEndColor().getAWTColor(), MISSING_COLOR.getAWTColor(), types, config.getAttribute());
        }
        if (config.getEventColorType() == EventColorType.VALUE_COLOR) {
            return new ValueColor(types, config.getAttribute(), MISSING_COLOR.getAWTColor());
        }
        return new EventTypeColor();
    }
}

