/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.fields.FilterMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class TreeNodeFilter {
    private static final Color FILTER_FG_COLOR = UIPlugin.getDefault().getFontColorToolkit().getFilterForegroundColor();
    private static final Color FILTER_BG_COLOR = UIPlugin.getDefault().getFontColorToolkit().getFilterBackgroundColor();
    private static final int FILTER_DELAY = 500;
    private static final int MAX_MATCHES = 8;
    private final TreeViewer tree;
    private final ILabelProvider lp;
    private boolean active;
    private long lastUpdateTime;
    private String filterText;
    private final Runnable asyncUpdater = new Runnable(){

        @Override
        public void run() {
            int delay = (int)(System.currentTimeMillis() - TreeNodeFilter.this.lastUpdateTime);
            if (TreeNodeFilter.this.filterText.length() == 0 || TreeNodeFilter.this.tree.getControl().isDisposed()) {
                TreeNodeFilter.this.active = false;
            } else if (delay >= 500) {
                TreeNodeFilter.this.createNewFilter();
                TreeNodeFilter.this.active = false;
            } else {
                Display.getCurrent().timerExec(500 - delay, (Runnable)this);
            }
        }
    };

    public static void install(TreeViewer treeViewer, final Text text, final boolean async) {
        final TreeNodeFilter filter = new TreeNodeFilter(treeViewer);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (text.getText().length() > 0) {
                    text.setForeground(FILTER_FG_COLOR);
                    text.setBackground(FILTER_BG_COLOR);
                    filter.updateFilter(text.getText(), async);
                } else {
                    text.setBackground(null);
                    text.setForeground(null);
                    filter.reset();
                }
            }
        });
    }

    public TreeNodeFilter(TreeViewer treeViewer) {
        this.tree = treeViewer;
        this.lp = (ILabelProvider)this.tree.getLabelProvider();
    }

    public void updateFilter(String text, boolean async) {
        this.filterText = FilterMatcher.autoAddKleene((String)text.toLowerCase(), (FilterMatcher.Where)FilterMatcher.Where.AFTER);
        if (async) {
            this.lastUpdateTime = System.currentTimeMillis();
            if (!this.active) {
                Display.getCurrent().timerExec(500, this.asyncUpdater);
                this.active = true;
            }
        } else {
            this.createNewFilter();
        }
    }

    public void reset() {
        this.filterText = "";
        this.tree.resetFilters();
        this.tree.collapseAll();
    }

    private void createNewFilter() {
        final HashSet<ITreeNode> includedNodes = new HashSet<ITreeNode>();
        ArrayList<ITreeNode> matches = new ArrayList<ITreeNode>(8);
        ITreeNode[] iTreeNodeArray = (ITreeNode[])this.tree.getInput();
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode root = iTreeNodeArray[n2];
            this.includeNode(root, false, includedNodes, matches);
            ++n2;
        }
        this.tree.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return includedNodes.contains(element);
            }
        }});
        if (matches.size() < 8) {
            for (ITreeNode node : matches) {
                this.tree.expandToLevel((Object)node, 0);
            }
        } else {
            this.tree.collapseAll();
        }
    }

    boolean includeNode(ITreeNode node, boolean hasIncludedParent, Set<ITreeNode> included, List<ITreeNode> matches) {
        if (FilterMatcher.getInstance().match(this.lp.getText((Object)node).toLowerCase(), this.filterText)) {
            if (matches.size() < 8) {
                matches.add(node);
            }
            hasIncludedParent = true;
        }
        boolean hasincludedChild = false;
        ITreeNode[] children = node.getChildren();
        if (children != null) {
            ITreeNode[] iTreeNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode child = iTreeNodeArray[n2];
                hasincludedChild = this.includeNode(child, hasIncludedParent, included, matches) || hasincludedChild;
                ++n2;
            }
        }
        if (hasincludedChild || hasIncludedParent) {
            included.add(node);
            return true;
        }
        return false;
    }
}

