/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.templates.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.templates.ui.TemplatesPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class TemplatesAction
extends AbstractAction {
    private Reference<Dialog> dialogWRef = new WeakReference<Object>(null);
    private Reference<TemplatesPanel> templatesPanelRef = new WeakReference<Object>(null);

    public TemplatesAction() {
        this.putValue("ShortDescription", NbBundle.getMessage(TemplatesAction.class, (String)"HINT_TemplatesAction"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Dialog dialog = this.dialogWRef.get();
        String string = System.getProperty("org.netbeans.modules.templates.actions.TemplatesAction.preselect");
        System.clearProperty("org.netbeans.modules.templates.actions.TemplatesAction.preselect");
        if (dialog == null || !dialog.isShowing()) {
            TemplatesPanel templatesPanel = new TemplatesPanel(string);
            JButton jButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(TemplatesAction.class, (String)"BTN_TemplatesPanel_CloseButton"));
            JButton jButton2 = new JButton();
            jButton2.setEnabled(false);
            OpenInEditorListener openInEditorListener = new OpenInEditorListener(templatesPanel, jButton2);
            jButton2.addActionListener(openInEditorListener);
            templatesPanel.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)openInEditorListener);
            Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(TemplatesAction.class, (String)"BTN_TemplatesPanel_OpenInEditorButton"));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)templatesPanel, NbBundle.getMessage(TemplatesAction.class, (String)"LBL_TemplatesPanel_Title"), false, new Object[]{jButton2, jButton}, (Object)jButton, 0, null, null);
            dialogDescriptor.setClosingOptions(null);
            dialogDescriptor.setHelpCtx(null);
            dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            this.dialogWRef = new WeakReference<Dialog>(dialog);
            this.templatesPanelRef = new WeakReference<TemplatesPanel>(templatesPanel);
        } else {
            TemplatesPanel templatesPanel;
            if (string != null && (templatesPanel = this.templatesPanelRef.get()) != null) {
                templatesPanel.select(string);
            }
            dialog.toFront();
        }
    }

    private static Set<Node> getNodes2Open(Node[] nodeArray) {
        HashSet<Node> hashSet = new HashSet<Node>(nodeArray.length);
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].isLeaf()) {
                hashSet.add(nodeArray[i]);
                continue;
            }
            hashSet.addAll(TemplatesAction.getNodes2Open(nodeArray[i].getChildren().getNodes(true)));
        }
        return hashSet;
    }

    private static class OpenInEditorListener
    implements ActionListener,
    PropertyChangeListener {
        TemplatesPanel tp;
        JButton b;

        public OpenInEditorListener(TemplatesPanel templatesPanel, JButton jButton) {
            this.tp = templatesPanel;
            this.b = jButton;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Node[] nodeArray = this.tp.getExplorerManager().getSelectedNodes();
            assert (nodeArray != null && nodeArray.length > 0) : "Selected templates cannot be null or empty.";
            Set set = TemplatesAction.getNodes2Open(nodeArray);
            assert (!set.isEmpty()) : "Selected templates to open cannot by empty for nodes " + Arrays.asList(nodeArray);
            for (Node node : set) {
                EditCookie editCookie = (EditCookie)node.getLookup().lookup(EditCookie.class);
                if (editCookie != null) {
                    editCookie.edit();
                    continue;
                }
                OpenCookie openCookie = (OpenCookie)node.getLookup().lookup(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                    continue;
                }
                assert (false) : "Node " + node + " has to have a EditCookie or OpenCookie.";
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                boolean bl = nodeArray != null && nodeArray.length > 0;
                for (int i = 0; bl && i < nodeArray.length; ++i) {
                    Node node = nodeArray[i];
                    EditCookie editCookie = (EditCookie)node.getLookup().lookup(EditCookie.class);
                    OpenCookie openCookie = (OpenCookie)node.getLookup().lookup(OpenCookie.class);
                    boolean bl2 = bl = editCookie != null || openCookie != null;
                    if (!bl) continue;
                    DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
                    assert (dataObject != null) : "DataObject for node " + node;
                    FileObject fileObject = dataObject.getPrimaryFile();
                    bl = fileObject.canRevert() || fileObject.getSize() > 0L;
                }
                this.b.setEnabled(bl);
            }
        }
    }
}

