/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.FieldWriterImpl;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.SubWriterHolderWriter;
import com.javafx.tools.doclets.formats.html.TagletOutputImpl;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.SerializedFormWriter;
import com.javafx.tools.doclets.internal.toolkit.taglets.TagletWriter;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSerialFieldWriter
extends FieldWriterImpl
implements SerializedFormWriter.SerialFieldWriter {
    ProgramElementDoc[] members = null;
    private boolean printedOverallAnchor = false;

    public HtmlSerialFieldWriter(SubWriterHolderWriter writer, ClassDoc classdoc) {
        super(writer, classdoc);
    }

    public List<FieldDoc> members(ClassDoc cd) {
        return Arrays.asList(cd.serializableFields());
    }

    protected void printTypeLinkNoDimension(Type type) {
        ClassDoc cd = type.asClassDoc();
        if (type.isPrimitive() || cd.isPackagePrivate()) {
            this.print(type.typeName());
        } else {
            this.writer.printLink(new LinkInfoImpl(8, type));
        }
    }

    @Override
    public Content getSerializableFieldsHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    @Override
    public Content getFieldsContentHeader(boolean isLastContent) {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        if (isLastContent) {
            li.addStyle(HtmlStyle.blockListLast);
        } else {
            li.addStyle(HtmlStyle.blockList);
        }
        return li;
    }

    @Override
    public Content getSerializableFields(String heading, Content serializableFieldsTree) {
        HtmlTree li = new HtmlTree(HtmlTag.LI);
        li.addStyle(HtmlStyle.blockList);
        if (serializableFieldsTree.isValid()) {
            if (!this.printedOverallAnchor) {
                li.addContent(this.writer.getMarkerAnchor("serializedForm"));
                this.printedOverallAnchor = true;
            }
            StringContent headingContent = new StringContent(heading);
            HtmlTree serialHeading = HtmlTree.HEADING(HtmlConstants.SERIALIZED_MEMBER_HEADING, headingContent);
            li.addContent(serialHeading);
            li.addContent(serializableFieldsTree);
        }
        return li;
    }

    @Override
    public void addMemberHeader(ClassDoc fieldType, String fieldTypeStr, String fieldDimensions, String fieldName, Content contentTree) {
        RawHtml nameContent = new RawHtml(fieldName);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.MEMBER_HEADING, nameContent);
        contentTree.addContent(heading);
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        if (fieldType == null) {
            ((Content)pre).addContent(fieldTypeStr);
        } else {
            RawHtml fieldContent = new RawHtml(this.writer.getLink(new LinkInfoImpl(8, (Type)fieldType)));
            ((Content)pre).addContent(fieldContent);
        }
        ((Content)pre).addContent(fieldDimensions + " ");
        ((Content)pre).addContent(fieldName);
        contentTree.addContent(pre);
    }

    @Override
    public void addMemberDeprecatedInfo(FieldDoc field, Content contentTree) {
        this.addDeprecatedInfo((ProgramElementDoc)field, contentTree);
    }

    @Override
    public void addMemberDescription(FieldDoc field, Content contentTree) {
        Tag[] tags;
        if (field.inlineTags().length > 0) {
            this.writer.addInlineComment((Doc)field, contentTree);
        }
        if ((tags = field.tags("serial")).length > 0) {
            this.writer.addInlineComment((Doc)field, tags[0], contentTree);
        }
    }

    @Override
    public void addMemberDescription(SerialFieldTag serialFieldTag, Content contentTree) {
        String serialFieldTagDesc = serialFieldTag.description().trim();
        if (!serialFieldTagDesc.isEmpty()) {
            RawHtml serialFieldContent = new RawHtml(serialFieldTagDesc);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, serialFieldContent);
            contentTree.addContent(div);
        }
    }

    @Override
    public void addMemberTags(FieldDoc field, Content contentTree) {
        TagletOutputImpl output = new TagletOutputImpl("");
        TagletWriter.genTagOuput(this.configuration().tagletManager, (Doc)field, this.configuration().tagletManager.getCustomTags((Doc)field), this.writer.getTagletWriterInstance(false), output);
        String outputString = output.toString().trim();
        HtmlTree dlTags = new HtmlTree(HtmlTag.DL);
        if (!outputString.isEmpty()) {
            RawHtml tagContent = new RawHtml(outputString);
            ((Content)dlTags).addContent(tagContent);
        }
        contentTree.addContent(dlTags);
    }

    @Override
    public boolean shouldPrintOverview(FieldDoc field) {
        if (!(this.configuration().nocomment || field.commentText().isEmpty() && !this.writer.hasSerializationOverviewTags(field))) {
            return true;
        }
        return field.tags("deprecated").length > 0;
    }
}

