/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.AbstractPackageIndexWriter;
import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.markup.HtmlAttr;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import java.io.IOException;

public class PackageIndexFrameWriter
extends AbstractPackageIndexWriter {
    public PackageIndexFrameWriter(ConfigurationImpl configuration, String filename) throws IOException {
        super(configuration, filename);
    }

    public static void generate(ConfigurationImpl configuration) {
        String filename = "overview-frame.html";
        try {
            PackageIndexFrameWriter packgen = new PackageIndexFrameWriter(configuration, filename);
            packgen.buildPackageIndexFile("doclet.Window_Overview", false);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void addPackagesList(PackageDoc[] packages, String text, String tableSummary, Content body) {
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, this.packagesLabel);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.indexContainer, heading);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addAttr(HtmlAttr.TITLE, this.packagesLabel.toString());
        for (int i = 0; i < packages.length; ++i) {
            if (packages[i] == null || this.configuration.nodeprecated && Util.isDeprecated((Doc)packages[i])) continue;
            ul.addContent(this.getPackage(packages[i]));
        }
        ((Content)div).addContent(ul);
        body.addContent(div);
    }

    protected Content getPackage(PackageDoc pd) {
        Content packageLinkContent;
        if (pd.name().length() > 0) {
            Content packageLabel = this.getPackageLabel(pd.name());
            packageLinkContent = this.getHyperLink(this.pathString(pd, "package-frame.html"), "", packageLabel, "", "packageFrame");
        } else {
            RawHtml packageLabel = new RawHtml("&lt;unnamed package&gt;");
            packageLinkContent = this.getHyperLink("package-frame.html", "", packageLabel, "", "packageFrame");
        }
        HtmlTree li = HtmlTree.LI(packageLinkContent);
        return li;
    }

    protected void addNavigationBarHeader(Content body) {
        RawHtml headerContent = this.configuration.packagesheader.length() > 0 ? new RawHtml(this.replaceDocRootDir(this.configuration.packagesheader)) : new RawHtml(this.replaceDocRootDir(this.configuration.header));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.bar, headerContent);
        body.addContent(heading);
    }

    protected void addOverviewHeader(Content body) {
    }

    protected void addAllClassesLink(Content body) {
        Content linkContent = this.getHyperLink("allclasses-frame.html", "", this.allclassesLabel, "", "packageFrame");
        HtmlTree div = HtmlTree.DIV(HtmlStyle.indexHeader, linkContent);
        body.addContent(div);
    }

    protected void addNavigationBarFooter(Content body) {
        HtmlTree p = HtmlTree.P(this.getSpace());
        body.addContent(p);
    }
}

