/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html.markup;

import com.javafx.tools.doclets.formats.html.markup.HtmlAttr;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.StringContent;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.DocletConstants;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HtmlTree
extends Content {
    private HtmlTag htmlTag;
    private Map<HtmlAttr, String> attrs = Collections.emptyMap();
    private List<Content> content = Collections.emptyList();
    public static final Content EMPTY;
    public static final BitSet NONENCODING_CHARS;

    public HtmlTree(HtmlTag tag) {
        this.htmlTag = HtmlTree.nullCheck(tag);
    }

    public HtmlTree(HtmlTag tag, Content ... contents) {
        this(tag);
        for (Content content : contents) {
            this.addContent(content);
        }
    }

    public void addAttr(HtmlAttr attrName, String attrValue) {
        if (this.attrs.isEmpty()) {
            this.attrs = new LinkedHashMap<HtmlAttr, String>();
        }
        this.attrs.put(HtmlTree.nullCheck(attrName), HtmlTree.nullCheck(attrValue));
    }

    public void addStyle(HtmlStyle style) {
        this.addAttr(HtmlAttr.CLASS, style.toString());
    }

    public void addContent(Content tagContent) {
        if (tagContent == EMPTY || tagContent.isValid()) {
            if (this.content.isEmpty()) {
                this.content = new ArrayList<Content>();
            }
            this.content.add(tagContent);
        }
    }

    public void addContent(String stringContent) {
        if (!this.content.isEmpty()) {
            Content lastContent = this.content.get(this.content.size() - 1);
            if (lastContent instanceof StringContent) {
                lastContent.addContent(stringContent);
            } else {
                this.addContent(new StringContent(stringContent));
            }
        } else {
            this.addContent(new StringContent(stringContent));
        }
    }

    protected static String encodeURL(String url) {
        byte[] urlBytes = url.getBytes(Charset.forName("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < urlBytes.length; ++i) {
            byte c = urlBytes[i];
            if (NONENCODING_CHARS.get(c & 0xFF)) {
                sb.append((char)c);
                continue;
            }
            sb.append(String.format("%%%02X", c & 0xFF));
        }
        return sb.toString();
    }

    public static HtmlTree A(String ref, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.A, HtmlTree.nullCheck(body));
        htmltree.addAttr(HtmlAttr.HREF, HtmlTree.encodeURL(ref));
        return htmltree;
    }

    public static HtmlTree A_NAME(String name, Content body) {
        HtmlTree htmltree = HtmlTree.A_NAME(name);
        htmltree.addContent(HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree A_NAME(String name) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.A);
        htmltree.addAttr(HtmlAttr.NAME, HtmlTree.nullCheck(name));
        return htmltree;
    }

    public static HtmlTree CAPTION(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.CAPTION, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree CODE(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.CODE, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree DD(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.DD, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree DL(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.DL, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree DIV(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.DIV, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree DIV(Content body) {
        return HtmlTree.DIV(null, body);
    }

    public static HtmlTree DT(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.DT, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree EM(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.EM, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree FRAME(String src, String name, String title, String scrolling) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.FRAME);
        htmltree.addAttr(HtmlAttr.SRC, HtmlTree.nullCheck(src));
        htmltree.addAttr(HtmlAttr.NAME, HtmlTree.nullCheck(name));
        htmltree.addAttr(HtmlAttr.TITLE, HtmlTree.nullCheck(title));
        if (scrolling != null) {
            htmltree.addAttr(HtmlAttr.SCROLLING, scrolling);
        }
        return htmltree;
    }

    public static HtmlTree FRAME(String src, String name, String title) {
        return HtmlTree.FRAME(src, name, title, null);
    }

    public static HtmlTree FRAMESET(String cols, String rows, String title, String onload) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.FRAMESET);
        if (cols != null) {
            htmltree.addAttr(HtmlAttr.COLS, cols);
        }
        if (rows != null) {
            htmltree.addAttr(HtmlAttr.ROWS, rows);
        }
        htmltree.addAttr(HtmlAttr.TITLE, HtmlTree.nullCheck(title));
        htmltree.addAttr(HtmlAttr.ONLOAD, HtmlTree.nullCheck(onload));
        return htmltree;
    }

    public static HtmlTree HEADING(HtmlTag headingTag, boolean printTitle, HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(headingTag, HtmlTree.nullCheck(body));
        if (printTitle) {
            htmltree.addAttr(HtmlAttr.TITLE, Util.stripHtml(body.toString()));
        }
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree HEADING(HtmlTag headingTag, HtmlStyle styleClass, Content body) {
        return HtmlTree.HEADING(headingTag, false, styleClass, body);
    }

    public static HtmlTree HEADING(HtmlTag headingTag, boolean printTitle, Content body) {
        return HtmlTree.HEADING(headingTag, printTitle, null, body);
    }

    public static HtmlTree HEADING(HtmlTag headingTag, Content body) {
        return HtmlTree.HEADING(headingTag, false, null, body);
    }

    public static HtmlTree HTML(String lang, Content head, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.HTML, HtmlTree.nullCheck(head), HtmlTree.nullCheck(body));
        htmltree.addAttr(HtmlAttr.LANG, HtmlTree.nullCheck(lang));
        return htmltree;
    }

    public static HtmlTree I(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.I, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree LI(Content body) {
        return HtmlTree.LI(null, body);
    }

    public static HtmlTree LI(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.LI, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree LINK(String rel, String type, String href, String title) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.LINK);
        htmltree.addAttr(HtmlAttr.REL, HtmlTree.nullCheck(rel));
        htmltree.addAttr(HtmlAttr.TYPE, HtmlTree.nullCheck(type));
        htmltree.addAttr(HtmlAttr.HREF, HtmlTree.nullCheck(href));
        htmltree.addAttr(HtmlAttr.TITLE, HtmlTree.nullCheck(title));
        return htmltree;
    }

    public static HtmlTree META(String httpEquiv, String content, String charSet) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.META);
        htmltree.addAttr(HtmlAttr.HTTP_EQUIV, HtmlTree.nullCheck(httpEquiv));
        htmltree.addAttr(HtmlAttr.CONTENT, HtmlTree.nullCheck(content));
        htmltree.addAttr(HtmlAttr.CHARSET, HtmlTree.nullCheck(charSet));
        return htmltree;
    }

    public static HtmlTree META(String name, String content) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.META);
        htmltree.addAttr(HtmlAttr.NAME, HtmlTree.nullCheck(name));
        htmltree.addAttr(HtmlAttr.CONTENT, HtmlTree.nullCheck(content));
        return htmltree;
    }

    public static HtmlTree NOSCRIPT(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.NOSCRIPT, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree P(Content body) {
        return HtmlTree.P(null, body);
    }

    public static HtmlTree P(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.P, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree SMALL(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.SMALL, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree STRONG(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.STRONG, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree SPAN(Content body) {
        return HtmlTree.SPAN(null, body);
    }

    public static HtmlTree SPAN(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.SPAN, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree TABLE(int border, int width, String summary, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TABLE, HtmlTree.nullCheck(body));
        htmltree.addAttr(HtmlAttr.BORDER, Integer.toString(border));
        htmltree.addAttr(HtmlAttr.WIDTH, Integer.toString(width));
        htmltree.addAttr(HtmlAttr.SUMMARY, HtmlTree.nullCheck(summary));
        return htmltree;
    }

    public static HtmlTree TABLE(HtmlStyle styleClass, int border, int cellPadding, int cellSpacing, String summary, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TABLE, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        htmltree.addAttr(HtmlAttr.BORDER, Integer.toString(border));
        htmltree.addAttr(HtmlAttr.CELLPADDING, Integer.toString(cellPadding));
        htmltree.addAttr(HtmlAttr.CELLSPACING, Integer.toString(cellSpacing));
        htmltree.addAttr(HtmlAttr.SUMMARY, HtmlTree.nullCheck(summary));
        return htmltree;
    }

    public static HtmlTree TABLE(int border, int cellPadding, int cellSpacing, String summary, Content body) {
        return HtmlTree.TABLE(null, border, cellPadding, cellSpacing, summary, body);
    }

    public static HtmlTree TD(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TD, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree TD(Content body) {
        return HtmlTree.TD(null, body);
    }

    public static HtmlTree TH(HtmlStyle styleClass, String scope, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TH, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        htmltree.addAttr(HtmlAttr.SCOPE, HtmlTree.nullCheck(scope));
        return htmltree;
    }

    public static HtmlTree TH(String scope, Content body) {
        return HtmlTree.TH(null, scope, body);
    }

    public static HtmlTree TITLE(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TITLE, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree TR(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TR, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree UL(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.UL, HtmlTree.nullCheck(body));
        htmltree.addStyle(HtmlTree.nullCheck(styleClass));
        return htmltree;
    }

    public boolean isEmpty() {
        return !this.hasContent() && !this.hasAttrs();
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public boolean hasAttrs() {
        return !this.attrs.isEmpty();
    }

    public boolean hasAttr(HtmlAttr attrName) {
        return this.attrs.containsKey((Object)attrName);
    }

    public boolean isValid() {
        switch (this.htmlTag) {
            case A: {
                return this.hasAttr(HtmlAttr.NAME) || this.hasAttr(HtmlAttr.HREF) && this.hasContent();
            }
            case BR: {
                return !this.hasContent() && (!this.hasAttrs() || this.hasAttr(HtmlAttr.CLEAR));
            }
            case FRAME: {
                return this.hasAttr(HtmlAttr.SRC) && !this.hasContent();
            }
            case HR: {
                return !this.hasContent();
            }
            case IMG: {
                return this.hasAttr(HtmlAttr.SRC) && this.hasAttr(HtmlAttr.ALT) && !this.hasContent();
            }
            case LINK: {
                return this.hasAttr(HtmlAttr.HREF) && !this.hasContent();
            }
            case META: {
                return this.hasAttr(HtmlAttr.CONTENT) && !this.hasContent();
            }
        }
        return this.hasContent();
    }

    public boolean isInline() {
        return this.htmlTag.blockType == HtmlTag.BlockType.INLINE;
    }

    public void write(StringBuilder contentBuilder) {
        if (!this.isInline() && !this.endsWithNewLine(contentBuilder)) {
            contentBuilder.append(DocletConstants.NL);
        }
        String tagString = this.htmlTag.toString();
        contentBuilder.append("<");
        contentBuilder.append(tagString);
        Iterator<HtmlAttr> iterator = this.attrs.keySet().iterator();
        String value = "";
        while (iterator.hasNext()) {
            HtmlAttr key = iterator.next();
            value = this.attrs.get((Object)key);
            contentBuilder.append(" ");
            contentBuilder.append(key.toString());
            if (value.isEmpty()) continue;
            contentBuilder.append("=\"");
            contentBuilder.append(value);
            contentBuilder.append("\"");
        }
        contentBuilder.append(">");
        for (Content c : this.content) {
            c.write(contentBuilder);
        }
        if (this.htmlTag.endTagRequired()) {
            contentBuilder.append("</");
            contentBuilder.append(tagString);
            contentBuilder.append(">");
        }
        if (!this.isInline()) {
            contentBuilder.append(DocletConstants.NL);
        }
    }

    static {
        int i;
        EMPTY = new StringContent("");
        NONENCODING_CHARS = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            NONENCODING_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            NONENCODING_CHARS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            NONENCODING_CHARS.set(i);
        }
        String noEnc = ":/?#[]@!$&'()*+,;=";
        noEnc = noEnc + "-._~";
        for (int i2 = 0; i2 < noEnc.length(); ++i2) {
            NONENCODING_CHARS.set(noEnc.charAt(i2));
        }
    }
}

