/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.arm;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.arm.ARMThreadContext;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.arm.ARMFrame;

public class ARMCurrentFrameGuess {
    private ARMThreadContext context;
    private JavaThread thread;
    private Address spFound;
    private Address fpFound;
    private Address pcFound;
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.runtime.arm.ARMFrame.DEBUG") != null;

    public ARMCurrentFrameGuess(ARMThreadContext context, JavaThread thread) {
        this.context = context;
        this.thread = thread;
    }

    public boolean run(long regionInBytesToSearch) {
        Address sp = this.context.getRegisterAsAddress(this.context.getSPRegisterIndex());
        Address pc = this.context.getRegisterAsAddress(this.context.getPCRegisterIndex());
        Address fp = this.context.getRegisterAsAddress(this.context.getFPRegisterIndex());
        if (DEBUG) {
            System.out.println("CurrentFrameGuess: sp = " + sp + ", fp = " + fp + ", pc = " + pc);
            System.out.println("CurrentFrameGuess: thread.lastsp = " + this.thread.getLastJavaSP() + ", thread.lastfp = " + this.thread.getLastJavaFP());
        }
        if (this.thread.getLastJavaSP() != null) {
            if (DEBUG) {
                System.out.println("CurrentFrameGuess: choosing last Java frame: sp = " + this.thread.getLastJavaSP() + ", fp = " + this.thread.getLastJavaFP());
            }
            this.setValues(this.thread.getLastJavaSP(), this.thread.getLastJavaFP(), this.thread.getLastJavaPC());
            return true;
        }
        if (sp == null) {
            return false;
        }
        Address end = sp.addOffsetTo(regionInBytesToSearch);
        VM vm = VM.getVM();
        this.setValues(null, null, null);
        if (vm.isJavaPCDbg(pc)) {
            if (vm.getInterpreter().contains(pc)) {
                if (DEBUG) {
                    System.out.println("CurrentFrameGuess: choosing interpreter frame: sp = " + sp + ", fp = " + fp + ", pc = " + pc);
                }
                this.setValues(sp, fp, pc);
                return true;
            }
            Address threadStackBase = this.thread.getStackBase();
            Address curSP = sp;
            long offset = 0L;
            while (curSP.lessThan(this.thread.getStackBase())) {
                block12: {
                    try {
                        RegisterMap map = this.thread.newRegisterMap(false);
                        for (Frame frame = new ARMFrame(curSP, null, pc); frame != null; frame = frame.sender(map)) {
                            if (!frame.isEntryFrame() || !frame.entryFrameIsFirst()) continue;
                            if (DEBUG) {
                                System.out.println("CurrentFrameGuess: Choosing sp = " + curSP + ", pc = " + pc);
                            }
                            this.setValues(curSP, null, pc);
                            return true;
                        }
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block12;
                        System.out.println("CurrentFrameGuess: Exception " + e + " at offset " + offset);
                    }
                }
                curSP = sp.addOffsetTo(offset += vm.getAddressSize());
            }
            return false;
        }
        return false;
    }

    public Address getSP() {
        return this.spFound;
    }

    public Address getFP() {
        return this.fpFound;
    }

    public Address getPC() {
        return this.pcFound;
    }

    private void setValues(Address sp, Address fp, Address pc) {
        this.spFound = sp;
        this.fpFound = fp;
        this.pcFound = pc;
    }
}

