/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers;

import com.jrockit.mc.common.IDescribable;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.triggers.ITrigger;
import com.jrockit.mc.rjmx.triggers.ITriggerAction;
import com.jrockit.mc.rjmx.triggers.ITriggerConstraint;
import com.jrockit.mc.rjmx.triggers.TriggerConstraintHolder;
import com.jrockit.mc.rjmx.triggers.internal.INotificationFactory;
import com.jrockit.mc.rjmx.triggers.internal.NotificationToolkit;
import com.jrockit.mc.rjmx.triggers.internal.NotificationTrigger;
import java.util.logging.Level;
import org.w3c.dom.Element;

public final class TriggerRule
implements Comparable<Object>,
IMRIValueListener,
IDescribable {
    private static final String DEFAULT_RULE_PATH = "<new group>";
    private static final String XML_ELEMENT_ACTION_CLASS = "notification_action_class";
    private static final String XML_ELEMENT_DESCRIPTION = "description";
    private static final String DEFAULT_DESCRIPTION = null;
    private volatile String m_name;
    private volatile ITrigger m_trigger;
    private volatile TriggerConstraintHolder m_constraintHolder = new TriggerConstraintHolder();
    private volatile ITriggerAction m_action;
    private String m_rulePath = "Default Group";
    private String m_description = null;

    public TriggerRule() {
        this.setName("<new rule>");
    }

    TriggerRule(String name, ITrigger trigger, ITriggerConstraint constraint, ITriggerAction action) {
        this.setName(name);
        this.setTrigger(trigger);
        this.addConstraint(constraint);
        this.setAction(action);
    }

    public TriggerRule(String name, ITrigger trigger, TriggerConstraintHolder constraintHolder, ITriggerAction action) {
        this.setName(name);
        this.setTrigger(trigger);
        this.setConstraintHolder(constraintHolder);
        this.setAction(action);
    }

    public ITriggerAction getAction() {
        return this.m_action;
    }

    public String getRulePath() {
        return this.m_rulePath;
    }

    public void setRulePath(String rulePath) {
        this.m_rulePath = rulePath;
    }

    public void setAction(ITriggerAction action) {
        this.m_action = action;
    }

    public void addConstraint(ITriggerConstraint constraint) {
        if (constraint != null) {
            this.getConstraintHolder().addConstraint(constraint);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public ITrigger getTrigger() {
        return this.m_trigger;
    }

    public void setTrigger(ITrigger trigger) {
        this.m_trigger = trigger;
    }

    public TriggerConstraintHolder getConstraintHolder() {
        return this.m_constraintHolder;
    }

    private void setConstraintHolder(TriggerConstraintHolder constraintHolder) {
        this.m_constraintHolder = constraintHolder;
    }

    public String toString() {
        return this.getName();
    }

    protected String getVerboseInformation() {
        StringBuffer sb = new StringBuffer();
        sb.append("----Notification rule----");
        sb.append("\nName: ");
        sb.append(this.getName());
        if (this.hasTrigger()) {
            sb.append("\nTrigger: ");
            sb.append(this.getTrigger().toString());
        } else {
            sb.append("\nNo trigger!");
        }
        if (this.hasConstraints()) {
            sb.append("\nConstraints:\n");
            sb.append(this.getConstraintHolder().toString());
        } else {
            sb.append("\nNoConstraints!\n");
        }
        if (this.hasAction()) {
            sb.append("Action: ");
            sb.append(this.getAction().toString());
        } else {
            sb.append("No action!");
        }
        return sb.toString();
    }

    public boolean hasConstraints() {
        return this.getConstraintHolder() != null && this.getConstraintHolder().getConstraintList().size() > 0;
    }

    public boolean hasTrigger() {
        return this.getTrigger() != null && NotificationToolkit.isComplete(this.getTrigger());
    }

    public boolean hasAction() {
        return this.getAction() != null;
    }

    @Override
    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public void initializeFromXml(Element node, INotificationFactory factory) {
        String ruleName = XmlToolkit.getSetting((Element)node, (String)"rule_name", (String)"<new rule>");
        String rulePath = XmlToolkit.getSetting((Element)node, (String)"rule_path", (String)DEFAULT_RULE_PATH);
        String description = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_DESCRIPTION, (String)DEFAULT_DESCRIPTION);
        NotificationTrigger trigger = factory.createTrigger();
        Element triggerNode = XmlToolkit.getOrCreateElement((Element)node, (String)trigger.getComponentTag());
        trigger.initializeFromXml(triggerNode, factory);
        TriggerConstraintHolder constraintHolder = new TriggerConstraintHolder();
        Element constraintsNode = XmlToolkit.getOrCreateElement((Element)node, (String)constraintHolder.getComponentTag());
        constraintHolder.initializeFromXml(constraintsNode, factory);
        Element actionNode = XmlToolkit.getOrCreateElement((Element)node, (String)"notification_action");
        String className = XmlToolkit.getSetting((Element)actionNode, (String)XML_ELEMENT_ACTION_CLASS, null);
        assert (className != null);
        ITriggerAction action = null;
        try {
            action = factory.createAction(className);
            action.initializeFromXml(actionNode);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Error while initializing the rule " + ruleName, e);
            return;
        }
        this.setDescription(description);
        this.setName(ruleName);
        this.setRulePath(rulePath);
        this.setTrigger(trigger);
        this.setConstraintHolder(constraintHolder);
        this.setAction(action);
    }

    public void exportToXml(Element parentNode) {
        Element ruleNode = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        XmlToolkit.setSetting((Element)ruleNode, (String)"rule_name", (String)this.getName());
        XmlToolkit.setSetting((Element)ruleNode, (String)"rule_path", (String)this.getRulePath());
        XmlToolkit.setSetting((Element)ruleNode, (String)XML_ELEMENT_DESCRIPTION, (String)this.getDescription());
        this.getTrigger().exportToXml(ruleNode);
        Element actionNode = XmlToolkit.createElement((Element)ruleNode, (String)"notification_action");
        XmlToolkit.setSetting((Element)actionNode, (String)XML_ELEMENT_ACTION_CLASS, (String)this.getAction().getClass().getName());
        this.getAction().exportToXml(actionNode);
        this.getConstraintHolder().exportToXml(ruleNode);
    }

    @Override
    public void valueChanged(MRIValueEvent event) {
        this.getTrigger().triggerOn(event.getConnectionHandle(), this, event);
    }

    public boolean isComplete() {
        return this.hasTrigger() && NotificationToolkit.isComplete(this.getTrigger()) && this.hasAction();
    }

    private String getComponentTag() {
        return "notification_rule";
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean isReady() {
        if (this.hasAction()) {
            return this.getAction().isReady();
        }
        return false;
    }
}

