/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.attributes;

import com.jrockit.mc.common.IMemberAccessor;
import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.rjmx.services.IReadOnlyAttribute;
import com.jrockit.mc.rjmx.ui.attributes.Messages;
import com.jrockit.mc.rjmx.ui.attributes.ValueColumnLabelProvider;
import com.jrockit.mc.rjmx.ui.column.Column;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.rjmx.ui.column.OptimisticComparator;
import com.jrockit.mc.rjmx.ui.column.TreeColumnComposite;
import com.jrockit.mc.rjmx.ui.column.TypedLabelProvider;
import com.jrockit.mc.ui.misc.TreeStructureContentProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;

public class AttributeTreeBuilder {
    public static final IMemberAccessor<Object, Object> VALUE_CELL_ACCESSOR = new IMemberAccessor<Object, Object>(){

        public Object getMember(Object o) {
            return o instanceof IReadOnlyAttribute ? ((IReadOnlyAttribute)o).getValue() : null;
        }
    };
    public static final IColumn NAME = new Column(Messages.AttributeInspector_NAME_COLUMN_HEADER, "name", new TypedLabelProvider<IReadOnlyAttribute>(IReadOnlyAttribute.class){

        @Override
        protected String getTextTyped(IReadOnlyAttribute attr) {
            return attr.getInfo().getName();
        }

        @Override
        protected String getDefaultText(Object element) {
            return element == null ? "" : element.toString();
        }

        @Override
        protected String getToolTipTextTyped(IReadOnlyAttribute attr) {
            StringBuilder sb = new StringBuilder();
            sb.append(Messages.AttributeInspector_NAME_COLUMN_HEADER).append(": ").append(attr.getInfo().getName()).append('\n');
            String desc = attr.getInfo().getDescription();
            if (desc != null && desc.length() > 0) {
                sb.append(Messages.AttributeInspector_DESCRIPTION_COLUMN_HEADER).append(": ").append(desc);
            }
            return sb.toString().trim();
        }
    }, new OptimisticComparator());
    public static final IColumn DESCRIPTION = new Column(Messages.AttributeInspector_DESCRIPTION_COLUMN_HEADER, "description", new TypedLabelProvider<IReadOnlyAttribute>(IReadOnlyAttribute.class){

        @Override
        protected String getTextTyped(IReadOnlyAttribute attr) {
            return this.getFirstRow(attr.getInfo().getDescription());
        }

        private String getFirstRow(String s) {
            if (s == null) {
                return "";
            }
            int firstRow = s.indexOf(10);
            return firstRow >= 0 ? s.substring(0, firstRow) : s;
        }

        @Override
        protected String getDefaultText(Object element) {
            return element == null ? "" : element.toString();
        }
    });
    public static final IColumn TYPE = new Column(Messages.AttributeInspector_TYPE_COLUMN_HEADER, "type", new TypedLabelProvider<IReadOnlyAttribute>(IReadOnlyAttribute.class){

        @Override
        protected String getTextTyped(IReadOnlyAttribute paramater) {
            return TypeHandling.simplifyType((String)paramater.getInfo().getType());
        }
    });
    public static final IColumn VALUE = new Column(Messages.AttributeInspector_VALUE_COLUMN_HEADER, null, "value", 0, new ValueColumnLabelProvider(), VALUE_CELL_ACCESSOR);

    private AttributeTreeBuilder() {
        throw new RuntimeException("AttributeTreeBuilder should not be instantiated");
    }

    public static TreeColumnComposite build(Composite parent, IDialogSettings settings) {
        TreeColumnComposite inspector = new TreeColumnComposite(parent, settings);
        inspector.getViewer().setUseHashlookup(true);
        inspector.getViewer().setContentProvider((IContentProvider)new TreeStructureContentProvider());
        return inspector;
    }

    public static TreeColumnComposite buildDefault(Composite parent, IDialogSettings settings) {
        TreeColumnComposite inspector = AttributeTreeBuilder.build(parent, settings);
        inspector.addColumns(NAME, VALUE, TYPE);
        return inspector;
    }
}

