/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.attributes;

import com.jrockit.mc.common.unit.DecimalPrefix;
import com.jrockit.mc.common.unit.IPrefix;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.rjmx.subscription.internal.UpdatePolicyToolkit;
import com.jrockit.mc.rjmx.ui.attributes.Messages;
import com.jrockit.mc.ui.misc.QuantityKindProposal;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpdateIntervalDialog
extends InputDialog {
    private static final LinearUnit MILLISECONDS = UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.MILLI);

    public UpdateIntervalDialog(Shell parentShell, int initialValue) {
        super(parentShell, Messages.UpdateIntervalDialog_DIALOG_TITLE, Messages.UpdateIntervalDialog_DIALOG_MESSAGE, MILLISECONDS.quantity((long)initialValue).interactiveFormat(), UpdateIntervalDialog.createValidator());
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        QuantityKindProposal.install((Text)this.getText(), (KindOfQuantity)UnitLookup.TIMESPAN);
        return control;
    }

    private static IInputValidator createValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                try {
                    UpdateIntervalDialog.parseInterval(newText);
                    return null;
                }
                catch (QuantityConversionException e) {
                    return e.getLocalizedMessage();
                }
            }
        };
    }

    public int getUpdateInterval() {
        try {
            return UpdateIntervalDialog.parseInterval(this.getValue());
        }
        catch (QuantityConversionException e) {
            return UpdatePolicyToolkit.getDefaultUpdateInterval();
        }
    }

    private static int parseInterval(String value) throws QuantityConversionException {
        LinearQuantity q = UnitLookup.TIMESPAN.parseInteractive(value);
        int interval = (int)q.longValueIn(MILLISECONDS, Integer.MAX_VALUE);
        if (interval <= 0) {
            throw QuantityConversionException.tooLow((IQuantity)q, (IQuantity)MILLISECONDS.quantity(1L));
        }
        return interval;
    }
}

