/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart.model;

import com.jrockit.mc.common.DataSeries;
import com.jrockit.mc.common.ITimestampedData;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.provider.ConstantField;
import com.jrockit.mc.flightrecorder.spi.EventOrder;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetFilterDescription;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.BarFLRIterator;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.ExpressionFilterFactory;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRDescriptorToolkit;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FilteredFLRIterator;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.GraphConfig;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.NotOperativeSetFilter;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.OperativeSetFilter;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.util.AlwaysTrueFilter;
import com.jrockit.mc.flightrecorder.util.AndFilter;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.Style;
import java.util.Iterator;
import java.util.Observable;

public final class FLRDataSeries
extends Observable
implements DataSeries<ITimestampedData> {
    public static final ConstantField ZERO_FIELD = new ConstantField("synthetic", Messages.FLR_DATA_SERIES_ZERO_FIELD_VALUE, (Object)0L);
    private final IServiceLocator m_serviceLocator;
    private final DataSeriesDescriptor m_dataseriesDescriptor;
    private final IView m_eventView;
    private final ITimeRange m_forcedRange;
    private final GraphConfig m_graphConfig;

    public FLRDataSeries(IServiceLocator locator, IView view, GraphConfig gc, DataSeriesDescriptor descriptor) {
        this.m_serviceLocator = locator;
        this.m_dataseriesDescriptor = descriptor;
        this.m_eventView = view;
        this.m_graphConfig = gc;
        this.m_forcedRange = FLRDescriptorToolkit.hasFilterExpression(this.m_dataseriesDescriptor) ? ITimeRange.INFINITE_RANGE : null;
    }

    public Iterator<ITimestampedData> createIterator(long minHint, long maxHint) {
        if (this.m_forcedRange != null) {
            this.m_eventView.setRange(this.m_forcedRange);
        }
        this.m_eventView.setEventTypes(FLRDescriptorToolkit.createAcceptor(this.m_serviceLocator, this.m_dataseriesDescriptor).getAcceptedSet());
        this.m_eventView.setExpansion(this.m_graphConfig.expansion);
        this.m_eventView.setFilter(this.createFilter(this.m_dataseriesDescriptor));
        if (Style.BAR.name().equals(this.m_graphConfig.name)) {
            this.m_eventView.setOrder(EventOrder.ASCENDING);
            return new BarFLRIterator(this.m_eventView.iterator(), this.m_graphConfig.yIdentifier);
        }
        this.m_eventView.setOrder(this.m_graphConfig.eventOrder);
        return new FilteredFLRIterator(this.m_eventView.iterator(), this.m_graphConfig.xIdentifier, this.m_graphConfig.yIdentifier);
    }

    private IEventFilter createFilter(DataSeriesDescriptor descriptor) {
        IEventFilter operativeSetFilter = this.createOperativeFilter(FLRDescriptorToolkit.getOperativeSet(descriptor));
        IEventFilter valueExpressionFilter = ExpressionFilterFactory.createFilter(FLRDescriptorToolkit.getFilterExpression(descriptor));
        if (valueExpressionFilter != null) {
            if (operativeSetFilter == AlwaysTrueFilter.getInstance()) {
                return valueExpressionFilter;
            }
            return new AndFilter(operativeSetFilter, valueExpressionFilter);
        }
        return operativeSetFilter;
    }

    private IEventFilter createOperativeFilter(OperativeSetFilterDescription od) {
        if (od == OperativeSetFilterDescription.ONLY_NOT_OPERATIVE_SET) {
            return new NotOperativeSetFilter();
        }
        if (od == OperativeSetFilterDescription.ONLY_OPERATIVE_SET) {
            return new OperativeSetFilter();
        }
        return AlwaysTrueFilter.getInstance();
    }

    public DataSeriesDescriptor getDescriptor() {
        return this.m_dataseriesDescriptor;
    }
}

