/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.fields.internal;

import com.jrockit.mc.rjmx.triggers.fields.internal.Field;

public class FloatField
extends Field {
    private float m_min;
    private float m_max;

    public FloatField(String fieldId, String fieldLabel, String fieldValue, String fieldDescription, String min, String max) throws Exception {
        super(fieldId, fieldLabel, fieldValue, fieldDescription);
        this.m_min = this.getLimit(min, Float.MIN_VALUE);
        this.m_max = this.getLimit(max, Float.MAX_VALUE);
        if (this.m_min > this.getFloat().floatValue()) {
            this.m_min = Float.MIN_VALUE;
        }
        if (this.m_max < this.getFloat().floatValue()) {
            this.m_max = Float.MAX_VALUE;
        }
    }

    @Override
    void initDefaultValue(String defaultValue) {
        this.m_min = Float.MIN_VALUE;
        this.m_max = Float.MAX_VALUE;
        if (!this.setValue(defaultValue)) {
            this.setValue(Integer.toString(0));
        }
    }

    @Override
    protected String parsedValue(String value) {
        return Float.toString(Float.parseFloat(value));
    }

    @Override
    public Float getFloat() {
        return Float.valueOf(this.getValue());
    }

    @Override
    public int getType() {
        return 8;
    }

    float getLimit(String limit, float defaultValue) {
        try {
            return Float.parseFloat(limit);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }
}

