/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.util;

import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class EventValueLookup {
    private static final char SEPARATOR = '#';
    private final Map<IEventType, IField> m_types = new HashMap<IEventType, IField>();
    private final HashSet<FieldType> m_fieldTypes;
    private IEventType m_lastType;
    private IField m_lastField;

    public EventValueLookup(Collection<FieldType> fieldTypes) {
        this.m_fieldTypes = new HashSet<FieldType>(fieldTypes);
    }

    public void add(IEventType eventType, String attributeIdentifier) {
        IField field = this.lookupField(eventType, attributeIdentifier);
        if (field != null && this.m_fieldTypes.contains((Object)field.getType())) {
            this.m_types.put(eventType, field);
        }
    }

    public Collection<IEventType> getEventTypes() {
        return this.m_types.keySet();
    }

    public void clear() {
        this.m_types.clear();
    }

    private IField lookupField(IEventType eventType, String attributeIdentifier) {
        String extractedPath = this.extractPath(attributeIdentifier);
        if (extractedPath != null) {
            if (extractedPath.equals(eventType.getPath())) {
                return eventType.getField(this.extractAttributeIdentifier(attributeIdentifier));
            }
            return null;
        }
        return eventType.getField(attributeIdentifier);
    }

    private String extractAttributeIdentifier(String fullAttributePath) {
        int index = EventValueLookup.findFirstSeparatorIndex(fullAttributePath);
        if (index >= 0 && index < fullAttributePath.length() - 1) {
            return fullAttributePath.substring(index + 1);
        }
        return fullAttributePath;
    }

    private String extractPath(String fullAttributePath) {
        int index = EventValueLookup.findFirstSeparatorIndex(fullAttributePath);
        if (index > 0) {
            return fullAttributePath.substring(0, index);
        }
        return null;
    }

    private static int findFirstSeparatorIndex(String attributeIdentifier) {
        return attributeIdentifier.indexOf(35);
    }

    public IField getField(IEventType theType) {
        if (theType != this.m_lastType) {
            this.m_lastField = this.m_types.get(theType);
            this.m_lastType = theType;
        }
        return this.m_lastField;
    }

    public void addAll(Collection<IEventType> types, String attributeIdentifier) {
        for (IEventType type : types) {
            this.add(type, attributeIdentifier);
        }
    }
}

