/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;

public final class HorizontalLayout
implements LayoutManager {
    private final boolean proportionalHeight;
    private final int hGap;

    public HorizontalLayout(boolean bl) {
        this(bl, 0);
    }

    public HorizontalLayout(boolean bl, int n) {
        this.proportionalHeight = bl;
        this.hGap = n;
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = container.getHeight() - insets.top - insets.bottom;
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            if (this.proportionalHeight) {
                int n4 = Math.min(dimension.height, n3);
                int n5 = (n3 - n4) / 2;
                component.setBounds(n, n2 + n5, dimension.width, n4);
            } else {
                component.setBounds(n, n2, dimension.width, n3);
            }
            n += this.hGap;
            n += dimension.width;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        int n = 0;
        int n2 = 0;
        for (Component component : container.getComponents()) {
            if (!component.isVisible() || component instanceof Box.Filler) continue;
            Dimension dimension2 = component.getPreferredSize();
            n = Math.max(n, dimension2.height);
            dimension.width += dimension2.width;
            ++n2;
        }
        dimension.width += (n2 - 1) * this.hGap;
        dimension.height += n;
        return dimension;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        int n = 0;
        int n2 = 0;
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getPreferredSize();
            n = Math.max(n, dimension2.height);
            dimension.width += dimension2.width;
            ++n2;
        }
        dimension.width += (n2 - 1) * this.hGap;
        dimension.height += n;
        return dimension;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

