/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.windows;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.windows.WinAppBundler;
import com.oracle.tools.packager.windows.WinResources;
import com.oracle.tools.packager.windows.WinServiceBundler;
import com.oracle.tools.packager.windows.WindowsBundlerParam;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WinExeBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(WinExeBundler.class.getName());
    public static final BundlerParamInfo<WinAppBundler> APP_BUNDLER = new WindowsBundlerParam<WinAppBundler>(I18N.getString("param.app-bundler.name"), I18N.getString("param.app-bundler.description"), "win.app.bundler", WinAppBundler.class, map -> new WinAppBundler(), null);
    public static final BundlerParamInfo<WinServiceBundler> SERVICE_BUNDLER = new WindowsBundlerParam<WinServiceBundler>(I18N.getString("param.service-bundler.name"), I18N.getString("param.service-bundler.description"), "win.service.bundler", WinServiceBundler.class, map -> new WinServiceBundler(), null);
    public static final BundlerParamInfo<File> CONFIG_ROOT = new WindowsBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, map -> {
        File file = new File((File)WindowsBundlerParam.BUILD_ROOT.fetchFrom((Map<String, ? super Object>)map), "windows");
        file.mkdirs();
        return file;
    }, (string, map) -> null);
    public static final StandardBundlerParam<Boolean> EXE_SYSTEM_WIDE = new StandardBundlerParam<Boolean>(I18N.getString("param.system-wide.name"), I18N.getString("param.system-wide.description"), "win.exe.systemWide", Boolean.class, map -> map.containsKey(WindowsBundlerParam.SYSTEM_WIDE.getID()) ? (Boolean)WindowsBundlerParam.SYSTEM_WIDE.fetchFrom((Map<String, ? super Object>)map) : Boolean.valueOf(false), (string, map) -> string == null || "null".equalsIgnoreCase((String)string) ? null : Boolean.valueOf(string));
    public static final BundlerParamInfo<File> EXE_IMAGE_DIR = new WindowsBundlerParam<File>(I18N.getString("param.image-dir.name"), I18N.getString("param.image-dir.description"), "win.exe.imageDir", File.class, map -> {
        File file = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)map);
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, "win-exe.image");
    }, (string, map) -> null);
    private static final String DEFAULT_EXE_PROJECT_TEMPLATE = "template.iss";
    private static final String TOOL_INNO_SETUP_COMPILER = "iscc.exe";
    public static final BundlerParamInfo<String> TOOL_INNO_SETUP_COMPILER_EXECUTABLE = new WindowsBundlerParam<String>(I18N.getString("param.iscc-path.name"), I18N.getString("param.iscc-path.description"), "win.exe.iscc.exe", String.class, map -> {
        for (String string : (System.getenv("PATH") + ";C:\\Program Files (x86)\\Inno Setup 5;C:\\Program Files\\Inno Setup 5").split(";")) {
            File file = new File(string.replace("\"", ""), TOOL_INNO_SETUP_COMPILER);
            if (!file.isFile()) continue;
            return file.toString();
        }
        return null;
    }, null);
    private static final String DEFAULT_INNO_SETUP_ICON = "icon_inno_setup.bmp";

    public WinExeBundler() {
        this.baseResourceLoader = WinResources.class;
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "exe";
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(WinAppBundler.getAppBundleParameters());
        linkedHashSet.addAll(WinExeBundler.getExeBundleParameters());
        return linkedHashSet;
    }

    public static Collection<BundlerParamInfo<?>> getExeBundleParameters() {
        return Arrays.asList(WindowsBundlerParam.DESCRIPTION, WindowsBundlerParam.COPYRIGHT, WindowsBundlerParam.LICENSE_FILE, WindowsBundlerParam.MENU_GROUP, WindowsBundlerParam.MENU_HINT, WindowsBundlerParam.SHORTCUT_HINT, WindowsBundlerParam.SYSTEM_WIDE, WindowsBundlerParam.TITLE, WindowsBundlerParam.VENDOR, WindowsBundlerParam.INSTALLDIR_CHOOSER);
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.bundle(map, file);
    }

    private static double findToolVersion(String string) {
        try {
            if (string == null || "".equals(string)) {
                return 0.0;
            }
            ProcessBuilder processBuilder = new ProcessBuilder(string, "/?");
            VersionExtractor versionExtractor = new VersionExtractor();
            IOUtils.exec(processBuilder, Log.isDebug(), true, versionExtractor);
            double d = versionExtractor.getVersion();
            Log.verbose(MessageFormat.format(I18N.getString("message.tool-version"), string, d));
            return d;
        }
        catch (Exception exception) {
            if (Log.isDebug()) {
                exception.printStackTrace();
            }
            return 0.0;
        }
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            double d;
            double d2;
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            APP_BUNDLER.fetchFrom(map).validate(map);
            for (BundlerParamInfo object : Arrays.asList(WindowsBundlerParam.APP_NAME, WindowsBundlerParam.COPYRIGHT, WindowsBundlerParam.DESCRIPTION, WindowsBundlerParam.MENU_GROUP, WindowsBundlerParam.TITLE, WindowsBundlerParam.VENDOR, WindowsBundlerParam.VERSION)) {
                String d3 = (String)object.fetchFrom(map);
                if (!(d3.contains("\n") | d3.contains("\r"))) continue;
                throw new ConfigException("Parmeter '" + object.getID() + "' cannot contain a newline.", "Change the value of '" + object.getID() + " so that it does not contain any newlines");
            }
            if (((String)WindowsBundlerParam.COPYRIGHT.fetchFrom(map)).length() > 100) {
                throw new ConfigException(I18N.getString("error.copyright-is-too-long"), I18N.getString("error.copyright-is-too-long.advice"));
            }
            if (map.containsKey(WindowsBundlerParam.LICENSE_FILE.getID())) {
                List list = (List)WindowsBundlerParam.APP_RESOURCES_LIST.fetchFrom(map);
                for (String d3 : (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(map)) {
                    boolean bl = false;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        RelativeFileSet relativeFileSet = (RelativeFileSet)iterator.next();
                        bl = bl || relativeFileSet.contains(d3);
                    }
                    if (bl) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), d3));
                }
            }
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
                SERVICE_BUNDLER.fetchFrom(map).validate(map);
            }
            if ((d2 = WinExeBundler.findToolVersion(TOOL_INNO_SETUP_COMPILER_EXECUTABLE.fetchFrom(map))) < (d = 5.0)) {
                Log.info(MessageFormat.format(I18N.getString("message.tool-wrong-version"), TOOL_INNO_SETUP_COMPILER, d2, d));
                throw new ConfigException(I18N.getString("error.iscc-not-found"), I18N.getString("error.iscc-not-found.advice"));
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    private boolean prepareProto(Map<String, ? super Object> map) throws IOException {
        File file = EXE_IMAGE_DIR.fetchFrom(map);
        File file2 = APP_BUNDLER.fetchFrom(map).doBundle(map, file, true);
        if (file2 == null) {
            return false;
        }
        List list = (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(map);
        if (list != null) {
            block0: for (Object object : (List)WindowsBundlerParam.APP_RESOURCES_LIST.fetchFrom(map)) {
                for (String string : list) {
                    if (!((RelativeFileSet)object).contains(string)) continue;
                    File file3 = new File(((RelativeFileSet)object).getBaseDirectory(), string);
                    IOUtils.copyFile(file3, new File(file, file3.getName()));
                    break block0;
                }
            }
        }
        for (Object object : (List)WindowsBundlerParam.FILE_ASSOCIATIONS.fetchFrom(map)) {
            File file4 = (File)WindowsBundlerParam.FA_ICON.fetchFrom((Map<String, Object>)object);
            if (file4 == null || !file4.exists()) continue;
            IOUtils.copyFile(file4, new File(file2, file4.getName()));
        }
        return (Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map) == false || (file2 = SERVICE_BUNDLER.fetchFrom(map).doBundle(map, file2, true)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> map, File file) {
        File file2;
        block34: {
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
            }
            if (!file.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
            }
            String string = TOOL_INNO_SETUP_COMPILER_EXECUTABLE.fetchFrom(map);
            if (string == null || !new File(string).isFile()) {
                Log.info(I18N.getString("error.iscc-not-found"));
                Log.info(MessageFormat.format(I18N.getString("message.iscc-file-string"), string));
                return null;
            }
            file2 = EXE_IMAGE_DIR.fetchFrom(map);
            file2.mkdirs();
            boolean bl = (Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(map);
            boolean bl2 = (Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(map);
            if (!bl && !bl2) {
                Log.verbose(I18N.getString("message.one-shortcut-required"));
                map.put(WindowsBundlerParam.MENU_HINT.getID(), (Object)true);
            }
            if (!this.prepareProto(map) || !this.prepareProjectConfig(map)) break block34;
            File file3 = this.getConfig_Script(map);
            if (file3.exists()) {
                Log.info(MessageFormat.format(I18N.getString("message.running-wsh-script"), file3.getAbsolutePath()));
                IOUtils.run("wscript", file3, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            }
            File file4 = this.buildEXE(map, file);
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    this.saveConfigFiles(map);
                }
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            return file4;
        }
        File file5 = null;
        try {
            if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                this.saveConfigFiles(map);
            }
            if (file2 != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(file2);
            } else if (file2 != null) {
                Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return file5;
        catch (IOException iOException) {
            File file6;
            try {
                iOException.printStackTrace();
                file6 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                        this.saveConfigFiles(map);
                    }
                    if (file2 != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(file2);
                    } else if (file2 != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    this.saveConfigFiles(map);
                }
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            return file6;
        }
    }

    private File getConfig_Script(Map<String, ? super Object> map) {
        return new File(EXE_IMAGE_DIR.fetchFrom(map), (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + "-post-image.wsf");
    }

    protected void saveConfigFiles(Map<String, ? super Object> map) {
        try {
            File file = CONFIG_ROOT.fetchFrom(map);
            if (this.getConfig_ExeProjectFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_ExeProjectFile(map), new File(file, this.getConfig_ExeProjectFile(map).getName()));
            }
            if (this.getConfig_Script(map).exists()) {
                IOUtils.copyFile(this.getConfig_Script(map), new File(file, this.getConfig_Script(map).getName()));
            }
            if (this.getConfig_SmallInnoSetupIcon(map).exists()) {
                IOUtils.copyFile(this.getConfig_SmallInnoSetupIcon(map), new File(file, this.getConfig_SmallInnoSetupIcon(map).getName()));
            }
            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getAppIdentifier(Map<String, ? super Object> map) {
        String string = (String)WindowsBundlerParam.IDENTIFIER.fetchFrom(map);
        if (string.length() > 126) {
            string = string.substring(0, 126);
        }
        return string;
    }

    private String getLicenseFile(Map<String, ? super Object> map) {
        List list = (List)WindowsBundlerParam.LICENSE_FILE.fetchFrom(map);
        if (list == null || list.isEmpty()) {
            return "";
        }
        return (String)list.get(0);
    }

    void validateValueAndPut(Map<String, String> map, String string, BundlerParamInfo<String> bundlerParamInfo, Map<String, ? super Object> map2) throws IOException {
        String string2 = bundlerParamInfo.fetchFrom(map2);
        if (string2.contains("\r") || string2.contains("\n")) {
            throw new IOException("Configuration Parameter " + bundlerParamInfo.getID() + " cannot contain multiple lines of text");
        }
        map.put(string, this.innosetupEscape(string2));
    }

    private String innosetupEscape(String string) {
        if (string.contains("\"") || !string.trim().equals(string)) {
            string = "\"" + string.replace("\"", "\"\"") + "\"";
        }
        return string;
    }

    boolean prepareMainProjectFile(Map<String, ? super Object> map) throws IOException {
        Object object;
        Object object2;
        Object object32;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PRODUCT_APP_IDENTIFIER", this.innosetupEscape(this.getAppIdentifier(map)));
        this.validateValueAndPut(hashMap, "APPLICATION_NAME", WindowsBundlerParam.APP_NAME, map);
        this.validateValueAndPut(hashMap, "APPLICATION_VENDOR", WindowsBundlerParam.VENDOR, map);
        this.validateValueAndPut(hashMap, "APPLICATION_VERSION", WindowsBundlerParam.VERSION, map);
        this.validateValueAndPut(hashMap, "INSTALLER_FILE_NAME", WindowsBundlerParam.INSTALLER_FILE_NAME, map);
        hashMap.put("APPLICATION_LAUNCHER_FILENAME", this.innosetupEscape(WinAppBundler.getLauncherName(map)));
        hashMap.put("APPLICATION_DESKTOP_SHORTCUT", (Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom(map) != false ? "returnTrue" : "returnFalse");
        hashMap.put("APPLICATION_MENU_SHORTCUT", (Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom(map) != false ? "returnTrue" : "returnFalse");
        this.validateValueAndPut(hashMap, "APPLICATION_GROUP", WindowsBundlerParam.MENU_GROUP, map);
        this.validateValueAndPut(hashMap, "APPLICATION_COMMENTS", WindowsBundlerParam.TITLE, map);
        this.validateValueAndPut(hashMap, "APPLICATION_COPYRIGHT", WindowsBundlerParam.COPYRIGHT, map);
        hashMap.put("APPLICATION_LICENSE_FILE", this.innosetupEscape(this.getLicenseFile(map)));
        hashMap.put("DISABLE_DIR_PAGE", WindowsBundlerParam.INSTALLDIR_CHOOSER.fetchFrom(map) != false ? "No" : "Yes");
        Boolean bl = (Boolean)EXE_SYSTEM_WIDE.fetchFrom(map);
        if (bl.booleanValue()) {
            hashMap.put("APPLICATION_INSTALL_ROOT", "{pf}");
            hashMap.put("APPLICATION_INSTALL_PRIVILEGE", "admin");
        } else {
            hashMap.put("APPLICATION_INSTALL_ROOT", "{localappdata}");
            hashMap.put("APPLICATION_INSTALL_PRIVILEGE", "lowest");
        }
        if (((Boolean)WindowsBundlerParam.BIT_ARCH_64.fetchFrom(map)).booleanValue()) {
            hashMap.put("ARCHITECTURE_BIT_MODE", "x64");
        } else {
            hashMap.put("ARCHITECTURE_BIT_MODE", "");
        }
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
            hashMap.put("RUN_FILENAME", this.innosetupEscape(WinServiceBundler.getAppSvcName(map)));
        } else {
            this.validateValueAndPut(hashMap, "RUN_FILENAME", WindowsBundlerParam.APP_NAME, map);
        }
        this.validateValueAndPut(hashMap, "APPLICATION_DESCRIPTION", WindowsBundlerParam.DESCRIPTION, map);
        hashMap.put("APPLICATION_SERVICE", (Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map) != false ? "returnTrue" : "returnFalse");
        hashMap.put("APPLICATION_NOT_SERVICE", (Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map) != false ? "returnFalse" : "returnTrue");
        hashMap.put("APPLICATION_APP_CDS_INSTALL", (Boolean)WindowsBundlerParam.UNLOCK_COMMERCIAL_FEATURES.fetchFrom(map) != false && (Boolean)WindowsBundlerParam.ENABLE_APP_CDS.fetchFrom(map) != false && ("install".equals(WindowsBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(map)) || "auto+install".equals(WindowsBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(map))) ? "returnTrue" : "returnFalse");
        hashMap.put("START_ON_INSTALL", (Boolean)WindowsBundlerParam.START_ON_INSTALL.fetchFrom(map) != false ? "-startOnInstall" : "");
        hashMap.put("STOP_ON_UNINSTALL", (Boolean)WindowsBundlerParam.STOP_ON_UNINSTALL.fetchFrom(map) != false ? "-stopOnUninstall" : "");
        hashMap.put("RUN_AT_STARTUP", (Boolean)WindowsBundlerParam.RUN_AT_STARTUP.fetchFrom(map) != false ? "-runAtStartup" : "");
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object32 : (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(map)) {
            object2 = (String)WindowsBundlerParam.APP_NAME.fetchFrom((Map<String, Object>)object32);
            if (((Boolean)WindowsBundlerParam.MENU_HINT.fetchFrom((Map<String, Object>)object32)).booleanValue()) {
                stringBuilder.append("Name: \"{group}\\");
                stringBuilder.append((String)object2);
                stringBuilder.append("\"; Filename: \"{app}\\");
                stringBuilder.append((String)object2);
                stringBuilder.append(".exe\"; IconFilename: \"{app}\\");
                stringBuilder.append((String)object2);
                stringBuilder.append(".ico\"\r\n");
            }
            if (!((Boolean)WindowsBundlerParam.SHORTCUT_HINT.fetchFrom((Map<String, Object>)object32)).booleanValue()) continue;
            stringBuilder.append("Name: \"{commondesktop}\\");
            stringBuilder.append((String)object2);
            stringBuilder.append("\"; Filename: \"{app}\\");
            stringBuilder.append((String)object2);
            stringBuilder.append(".exe\";  IconFilename: \"{app}\\");
            stringBuilder.append((String)object2);
            stringBuilder.append(".ico\"\r\n");
        }
        hashMap.put("SECONDARY_LAUNCHERS", stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder();
        object32 = WindowsBundlerParam.APP_REGISTRY_NAME.fetchFrom(map);
        object2 = (List)WindowsBundlerParam.FILE_ASSOCIATIONS.fetchFrom(map);
        for (int i = 0; i < object2.size(); ++i) {
            object = (Map)object2.get(i);
            String string = (String)WindowsBundlerParam.FA_DESCRIPTION.fetchFrom((Map<String, Object>)object);
            File file = (File)WindowsBundlerParam.FA_ICON.fetchFrom((Map<String, Object>)object);
            List list = (List)WindowsBundlerParam.FA_EXTENSIONS.fetchFrom((Map<String, Object>)object);
            String string2 = (String)object32 + "File";
            if (i > 0) {
                string2 = string2 + "." + i;
            }
            if (list == null) {
                Log.info(I18N.getString("message.creating-association-with-null-extension"));
            } else {
                for (Object object4 : list) {
                    if (bl.booleanValue()) {
                        stringBuilder2.append("Root: HKCR; Subkey: \".").append((String)object4).append("\"; ValueType: string; ValueName: \"\"; ValueData: \"").append(string2).append("\"; Flags: uninsdeletevalue\r\n");
                        continue;
                    }
                    stringBuilder2.append("Root: HKCU; Subkey: \"Software\\Classes\\.").append((String)object4).append("\"; ValueType: string; ValueName: \"\"; ValueData: \"").append(string2).append("\"; Flags: uninsdeletevalue\r\n");
                }
            }
            if (list != null && !list.isEmpty()) {
                Object object4;
                String string3 = (String)list.get(0);
                object4 = (List)WindowsBundlerParam.FA_CONTENT_TYPE.fetchFrom((Map<String, Object>)object);
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (bl.booleanValue()) {
                        stringBuilder2.append("Root: HKCR; Subkey: \"Mime\\Database\\Content Type\\").append(string4).append("\"; ValueType: string; ValueName: \"Extension\"; ValueData: \".").append(string3).append("\"; Flags: uninsdeletevalue\r\n");
                        continue;
                    }
                    stringBuilder2.append("Root: HKCU; Subkey: \"Software\\Classes\\Mime\\Database\\Content Type\\").append(string4).append("\"; ValueType: string; ValueName: \"Extension\"; ValueData: \".").append(string3).append("\"; Flags: uninsdeletevalue\r\n");
                }
            }
            if (bl.booleanValue()) {
                stringBuilder2.append("Root: HKCR; Subkey: \"").append(string2).append("\"; ValueType: string; ValueName: \"\"; ValueData: \"").append(string).append("\"; Flags: uninsdeletekey\r\n");
            } else {
                stringBuilder2.append("Root: HKCU; Subkey: \"Software\\Classes\\").append(string2).append("\"; ValueType: string; ValueName: \"\"; ValueData: \"").append(string).append("\"; Flags: uninsdeletekey\r\n");
            }
            if (file != null && file.exists()) {
                if (bl.booleanValue()) {
                    stringBuilder2.append("Root: HKCR; Subkey: \"").append(string2).append("\\DefaultIcon\"; ValueType: string; ValueName: \"\"; ValueData: \"{app}\\").append(file.getName()).append("\"\r\n");
                } else {
                    stringBuilder2.append("Root: HKCU; Subkey: \"Software\\Classes\\").append(string2).append("\\DefaultIcon\"; ValueType: string; ValueName: \"\"; ValueData: \"{app}\\").append(file.getName()).append("\"\r\n");
                }
            }
            if (bl.booleanValue()) {
                stringBuilder2.append("Root: HKCR; Subkey: \"").append(string2).append("\\shell\\open\\command\"; ValueType: string; ValueName: \"\"; ValueData: \"\"\"{app}\\").append((String)WindowsBundlerParam.APP_NAME.fetchFrom(map)).append("\"\" \"\"%1\"\"\"\r\n");
                continue;
            }
            stringBuilder2.append("Root: HKCU; Subkey: \"Software\\Classes\\").append(string2).append("\\shell\\open\\command\"; ValueType: string; ValueName: \"\"; ValueData: \"\"\"{app}\\").append((String)WindowsBundlerParam.APP_NAME.fetchFrom(map)).append("\"\" \"\"%1\"\"\"\r\n");
        }
        if (stringBuilder2.length() > 0) {
            hashMap.put("FILE_ASSOCIATIONS", "ChangesAssociations=yes\r\n\r\n[Registry]\r\n" + stringBuilder2.toString());
        } else {
            hashMap.put("FILE_ASSOCIATIONS", "");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.getConfig_ExeProjectFile(map)));
        object = this.preprocessTextResource("package/windows/" + this.getConfig_ExeProjectFile(map).getName(), I18N.getString("resource.inno-setup-project-file"), DEFAULT_EXE_PROJECT_TEMPLATE, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map), (File)WindowsBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        bufferedWriter.write((String)object);
        ((Writer)bufferedWriter).close();
        return true;
    }

    private boolean prepareProjectConfig(Map<String, ? super Object> map) throws IOException {
        this.prepareMainProjectFile(map);
        File file = this.getConfig_SmallInnoSetupIcon(map);
        this.fetchResource("package/windows/" + file.getName(), I18N.getString("resource.setup-icon"), DEFAULT_INNO_SETUP_ICON, file, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)WindowsBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        this.fetchResource("package/windows/" + this.getConfig_Script(map).getName(), I18N.getString("resource.post-install-script"), (String)null, this.getConfig_Script(map), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)WindowsBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        return true;
    }

    private File getConfig_SmallInnoSetupIcon(Map<String, ? super Object> map) {
        return new File(EXE_IMAGE_DIR.fetchFrom(map), (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + "-setup-icon.bmp");
    }

    private File getConfig_ExeProjectFile(Map<String, ? super Object> map) {
        return new File(EXE_IMAGE_DIR.fetchFrom(map), (String)WindowsBundlerParam.APP_NAME.fetchFrom(map) + ".iss");
    }

    private File buildEXE(Map<String, ? super Object> map, File file) throws IOException {
        Log.verbose(MessageFormat.format(I18N.getString("message.outputting-to-location"), file.getAbsolutePath()));
        file.mkdirs();
        ProcessBuilder processBuilder = new ProcessBuilder(TOOL_INNO_SETUP_COMPILER_EXECUTABLE.fetchFrom(map), "/o" + file.getAbsolutePath(), this.getConfig_ExeProjectFile(map).getAbsolutePath());
        processBuilder = processBuilder.directory(EXE_IMAGE_DIR.fetchFrom(map));
        IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        Log.info(MessageFormat.format(I18N.getString("message.output-location"), file.getAbsolutePath()));
        File file2 = null;
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file3 : fileArray) {
                if (!file3.getName().endsWith(".exe") || file3.lastModified() <= l) continue;
                file2 = file3;
                l = file3.lastModified();
            }
        }
        return file2;
    }

    static class VersionExtractor
    extends PrintStream {
        double version = 0.0;

        public VersionExtractor() {
            super(new ByteArrayOutputStream());
        }

        double getVersion() {
            if (this.version == 0.0) {
                String string = new String(((ByteArrayOutputStream)this.out).toByteArray());
                Pattern pattern = Pattern.compile("Inno Setup (\\d+.?\\d*)");
                Matcher matcher = pattern.matcher(string);
                if (matcher.find()) {
                    String string2 = matcher.group(1);
                    this.version = new Double(string2);
                }
            }
            return this.version;
        }
    }
}

