/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.templates.ui;

import java.awt.Panel;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.templates.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RenameTemplatePanel
extends Panel {
    private Set<String> otherFileNames;
    private boolean isLicense = false;
    private DialogDescriptor dd;
    private NotificationLineSupport notificationLineSupport;
    private JLabel displayNameLabel;
    private JTextField displayNameTextField;
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;

    public RenameTemplatePanel(boolean bl) {
        this.initComponents();
        this.fileNameTextField.setEditable(bl);
        this.fileNameTextField.getDocument().addDocumentListener(new NameDocumentListener());
    }

    private void initComponents() {
        this.displayNameLabel = new JLabel();
        this.displayNameTextField = new JTextField();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.displayNameLabel.setLabelFor(this.displayNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.displayNameLabel, (String)NbBundle.getMessage(RenameTemplatePanel.class, (String)"RenameTemplatePanel.displayNameLabel.text"));
        this.fileNameLabel.setLabelFor(this.fileNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileNameLabel, (String)NbBundle.getMessage(RenameTemplatePanel.class, (String)"RenameTemplatePanel.fileNameLabel.text"));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayNameLabel).addComponent(this.fileNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileNameTextField, -1, 204, Short.MAX_VALUE).addComponent(this.displayNameTextField, -1, 204, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayNameLabel).addComponent(this.displayNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameLabel).addComponent(this.fileNameTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    void setFileName(String string) {
        this.fileNameTextField.setText(string);
    }

    void setFileDisplayName(String string) {
        this.displayNameTextField.setText(string);
    }

    String getFileName() {
        return this.fileNameTextField.getText();
    }

    String getFileDisplayName() {
        return this.displayNameTextField.getText();
    }

    void setIsLicense(boolean bl) {
        this.isLicense = bl;
    }

    void setOtherFileNames(Set<String> set) {
        this.otherFileNames = set;
    }

    void setDescriptor(DialogDescriptor dialogDescriptor) {
        this.dd = dialogDescriptor;
        this.notificationLineSupport = dialogDescriptor.createNotificationLineSupport();
    }

    private void checkName() {
        boolean bl;
        String string = this.fileNameTextField.getText();
        boolean bl2 = bl = this.otherFileNames != null && this.otherFileNames.contains(string);
        if (bl) {
            this.notificationLineSupport.setErrorMessage(Bundle.Err_FileNameExists());
        } else {
            boolean bl3 = bl = this.isLicense && RenameTemplatePanel.checkLicenseClash(string);
            if (bl) {
                this.notificationLineSupport.setErrorMessage(Bundle.RenameTemplatePanel_license_warning_text("license-", ".txt"));
            } else {
                this.notificationLineSupport.clearMessages();
            }
        }
        this.dd.setValid(!bl);
    }

    private static boolean checkLicenseClash(String string) {
        return !string.startsWith("license-") || !string.endsWith(".txt");
    }

    private class NameDocumentListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            RenameTemplatePanel.this.checkName();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            RenameTemplatePanel.this.checkName();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            RenameTemplatePanel.this.checkName();
        }
    }
}

