/*
 * Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/*
 * This file primarily consists of all the error and warning messages, that
 * are used in JLI_ReportErrorMessage. All message must be defined here, in
 * order to help with localizing the messages.
 */

#ifndef _EMESSAGES_H
#define _EMESSAGES_H

#define GEN_ERROR       "Error: A fatal exception has occurred. Program will exit."
#define JNI_ERROR       "Error: A JNI error has occurred, please check your installation and try again"
#define JNI_ERROR1      "Error: can't find JNI interfaces in: %s"

#define ARG_WARN        "Warning: %s option is no longer supported."

#define ARG_ERROR1      "Error: %s requires class path specification"
#define ARG_ERROR2      "Error: %s requires jar file specification"
#define ARG_ERROR3      "Error: The -J option should not be followed by a space."

#define JVM_ERROR1      "Error: Could not create the Java Virtual Machine.\n" GEN_ERROR
#define JVM_ERROR2      "Error: Could not detach main thread.\n" JNI_ERROR
#define JVM_ERROR3      "Error: SPARC V8 processor detected;  Required V9 processors or better.\nUse JDK5 client compiler for V8 processors.\n" JVM_ERROR1

#define JAR_ERROR1      "Error: Failed to load Main-Class manifest attribute from\n%s\n%s"
#define JAR_ERROR2      "Error: Unable to access jarfile %s"
#define JAR_ERROR3      "Error: Invalid or corrupt jarfile %s"

#define CLS_ERROR1      "Error: Could not find the main class %s.\n" JNI_ERROR
#define CLS_ERROR2      "Error: Failed to load Main Class: %s\n%s"
#define CLS_ERROR3      "Error: No main method found in specified class.\n" GEN_ERROR
#define CLS_ERROR4      "Error: Main method not public\n" GEN_ERROR
#define CLS_ERROR5      "Error: main-class: attribute exceeds system limits of %d bytes\n" GEN_ERROR

#define CFG_WARN1       "Warning: %s VM not supported; %s VM will be used"
#define CFG_WARN2       "Warning: No leading - on line %d of `%s'"
#define CFG_WARN3       "Warning: Missing VM type on line %d of `%s'"
#define CFG_WARN4       "Warning: Missing server class VM on line %d of `%s'"
#define CFG_WARN5       "Warning: Unknown VM type on line %d of `%s'"

#define CFG_ERROR1      "Error: Corrupt jvm.cfg file; cycle in alias list."
#define CFG_ERROR2      "Error: Unable to resolve VM alias %s"
#define CFG_ERROR3      "Error: %s VM not supported"
#define CFG_ERROR4      "Error: Unable to locate JRE meeting specification \"%s\""
#define CFG_ERROR5      "Error: Could not determine application home."
#define CFG_ERROR6      "Error: could not open `%s'"
#define CFG_ERROR7      "Error: no known VMs. (check for corrupt jvm.cfg file)"
#define CFG_ERROR8      "Error: missing `%s' JVM at `%s'.\nPlease install or use the JRE or JDK that contains these missing components."
#define CFG_ERROR9      "Error: could not determine JVM type."


#define SPC_ERROR1      "Error: Syntax error in version specification \"%s\""

#define JRE_ERROR1      "Error: Could not find Java SE Runtime Environment."
#define JRE_ERROR2      "Error: This Java instance does not support a %d-bit JVM.\nPlease install the desired version."
#define JRE_ERROR3      "Error: Improper value at line %d."
#define JRE_ERROR4      "Error: trying to exec %s.\nCheck if file exists and permissions are set correctly."
#define JRE_ERROR5      "Error: Failed to start a %d-bit JVM process from a %d-bit JVM."
#define JRE_ERROR6      "Error: Verify all necessary Java SE components have been installed.\n(Solaris SPARC 64-bit components must be installed after 32-bit components.)"
#define JRE_ERROR7      "Error: Either 64-bit processes are not supported by this platform\nor the 64-bit components have not been installed."
#define JRE_ERROR8      "Error: could not find "
#define JRE_ERROR9      "Error: Unable to resolve %s"
#define JRE_ERROR10     "Error: Unable to resolve current executable"
#define JRE_ERROR11     "Error: Path length exceeds maximum length (PATH_MAX)"
#define JRE_ERROR12     "Error: Exec of %s failed"
#define JRE_ERROR13     "Error: String processing operation failed"

#define DLL_ERROR1      "Error: dl failure on line %d"
#define DLL_ERROR2      "Error: failed %s, because %s"
#define DLL_ERROR3      "Error: could not find executable %s"
#define DLL_ERROR4      "Error: loading: %s"

#define REG_ERROR1      "Error: opening registry key '%s'"
#define REG_ERROR2      "Error: Failed reading value of registry key:\n\t%s\\CurrentVersion"
#define REG_ERROR3      "Error: Registry key '%s'\\CurrentVersion'\nhas value '%s', but '%s' is required."
#define REG_ERROR4      "Failed reading value of registry key:\n\t%s\\%s\\JavaHome"

#define SYS_ERROR1      "Error: CreateProcess(%s, ...) failed:"
#define SYS_ERROR2      "Error: WaitForSingleObject() failed."



#endif /* _EMESSAGES_H */
