/* config.h */

#ifndef __CONFIG_H
#define __CONFIG_H

#include "copyrite.h"
#include "options.h"

#ifdef __GNUC__
#define INLINE inline
#else
#define INLINE
#endif


/*----- Miscellaneous other stuff -----*/

#define God(x)  ((x) == GOD)

/* limit on player name length */
#define PLAYER_NAME_LIMIT 16

/* magic cookies */
#define LOOKUP_TOKEN '*'
#define NUMBER_TOKEN '#'
#define ARG_DELIMITER '='

/* magic command cookies */
#define SAY_TOKEN '"'
#define POSE_TOKEN ':'
#define SEMI_POSE_TOKEN ';'
#define EMIT_TOKEN '\\'
#define CHAT_TOKEN '+'

/* delimiter for lists of exit aliases */
#define EXIT_DELIMITER ';'

#define OBJECT_ENDOWMENT(cost) (((cost)-5)/5)

/* added for recycling, return value of object */
#define OBJECT_DEPOSIT(pennies) ((pennies)*5+5)

#define QUIT_COMMAND "QUIT"
#define WHO_COMMAND "WHO"
#define LOGOUT_COMMAND "LOGOUT"
#define INFO_COMMAND "INFO"
#define INFO_VERSION "1"
#define DOING_COMMAND "DOING"

#ifdef RWHO_SEND
#ifdef FULL_RWHO
#define RWHO_COMMAND "RWHO"
#endif
#endif

#define PREFIX_COMMAND "OUTPUTPREFIX"
#define SUFFIX_COMMAND "OUTPUTSUFFIX"

/*----- intrface.c stuff -----*/

#define MAX_OUTPUT 16384
/* How much output buffer space must be left before we flush the
 * buffer? Reportedly, using '0' fixes problems with Win32 port,
 * and may be more efficient in network use. Using (MAX_OUTPUT / 2)
 * is how it's been done in the past. You get to pick.
 */
#define SPILLOVER_THRESHOLD	0
/* #define SPILLOVER_THRESHOLD  (MAX_OUTPUT / 2) */
#define COMMAND_TIME_MSEC 1000	/* time slice length in milliseconds */
#define COMMAND_BURST_SIZE 100	/* commands allowed per user in a burst */
#define COMMANDS_PER_TIME 1	/* commands per time slice after burst */


/* ---  DO NOT CHANGE ANYTHING BELOW THIS LINE --- */

typedef struct fblock_header FBLKHDR;
typedef struct filecache_block FBLOCK;

#define FBLOCK_SIZE (256 - sizeof(FBLKHDR))

struct fblock_header {
  FBLOCK *nxt;
  int nchars;
};

struct filecache_block {
  FBLKHDR hdr;
  char data[FBLOCK_SIZE];
};

typedef struct options_table OPTTAB;

struct options_table {
  char mud_name[128];
  int port;
  char input_db[256];
  char output_db[256];
  char crash_db[256];
  char mail_db[256];
  int player_start;
  int master_room;
  int idle_timeout;
  int dump_interval;
  char dump_message[256];
  char dump_complete[256];
  long dump_counter;
  int ident_timeout;
  int max_logins;
  int whisper_loudness;
  int paycheck;
  int starting_money;
  int starting_quota;
  int player_queue_limit;
  int queue_chunk;
  int active_q_chunk;
  int func_nest_lim;
  int func_invk_lim;
  char money_singular[32];
  int dbcomp;
  char money_plural[32];
  char compressprog[256];
  char uncompressprog[256];
  char help_file[256];
  char help_index[256];
  char news_file[256];
  char news_index[256];
  char events_file[256];
  char events_index[256];
#if (CHAT_SYSTEM > 3)
  char chatdb[256];
  int max_player_chans;
  int max_channels;
  int chan_cost;
#endif
  char connect_file[256];
  char motd_file[256];
  char wizmotd_file[256];
  char newuser_file[256];
  char register_file[256];
  char quit_file[256];
  char down_file[256];
  char full_file[256];
  char guest_file[256];
  FBLOCK *connect_fcache;
  FBLOCK *motd_fcache;
  FBLOCK *wizmotd_fcache;
  FBLOCK *newuser_fcache;
  FBLOCK *register_fcache;
  FBLOCK *quit_fcache;
  FBLOCK *down_fcache;
  FBLOCK *full_fcache;
  FBLOCK *guest_fcache;
  int log_commands;
  int log_huhs;
  int log_forces;
  int log_walls;
  int login_allow;
  int guest_allow;
  int create_allow;
  int daytime;
  int player_flags;
  int room_flags;
  int exit_flags;
  int thing_flags;
  int player_toggles;
  int room_toggles;
  int exit_toggles;
  int thing_toggles;
  int rwho_interval;
  long rwho_counter;
  int rwho_port;
  char rwho_host[64];
  char rwho_pass[64];
#ifdef USE_WARNINGS
  int warn_interval;
  long warn_counter;
#endif
  int base_room;
  int use_dns;
};

extern OPTTAB options;

#define DUMP_INTERVAL       (options.dump_interval)
#define DUMP_NOFORK_MESSAGE  (options.dump_message)
#define DUMP_NOFORK_COMPLETE (options.dump_complete)
#define INACTIVITY_LIMIT    (options.idle_timeout)

#ifdef LOGIN_LIMIT
#define MAX_LOGINS      (options.max_logins)
#endif

#define  HELPTEXT	(options.help_file)
#define  HELPINDX	(options.help_index)

#define  NEWS_FILE      (options.news_file)
#define  NEWSINDX       (options.news_index)

#ifdef EVENTS
#define EVENT_FILE            (options.events_file)
#define EVENTINDX             (options.events_index)
#endif

/* dbrefs are in the conf file */

#define TINYPORT         (options.port)
#define PLAYER_START     (options.player_start)
#define MASTER_ROOM      (options.master_room)
#define MONEY            (options.money_singular)
#define MONIES           (options.money_plural)
#define WHISPER_LOUDNESS	(options.whisper_loudness)

#define START_BONUS      (options.starting_money)
#define PAY_CHECK        (options.paycheck)
#define START_QUOTA      (options.starting_quota)

#define QUEUE_QUOTA      (options.player_queue_limit)

#define MUDNAME          (options.mud_name)
#define DEF_DB_IN	 (options.input_db)
#define DEF_DB_OUT	 (options.output_db)

#define BASE_ROOM        (options.base_room)

#ifdef RWHO_SEND
#define RWHO_INTERVAL    (options.rwho_interval)
#define RWHOSERV         (options.rwho_host)
#define RWHOPORT         (options.rwho_port)
#define RWHOPASS         (options.rwho_pass)
#endif


#ifdef WIN32
/* --------------- Stuff for Win32 services ------------------ */
/*

   NJG:

   When "exit" is called to handle an error condition, we really want to
   terminate the game thread, not the whole process.

 */

#define exit(arg) Win32_Exit (arg)
void Win32_Exit(int exit_code);
#define malloc(arg) Win32_malloc (arg)
#define calloc(arg1, arg2) Win32_calloc (arg1, arg2)
#define realloc(arg1, arg2) Win32_realloc (arg1, arg2)
#define free(arg) Win32_free (arg)
void *Win32_malloc(unsigned int size);
void *Win32_calloc(unsigned int num, unsigned int size);
void *Win32_realloc(void *memblock, unsigned int size);
void Win32_free(void *memblock);
void Win32_return_memory_used(long *mallocs,
			      long *frees,
			      long *allocated,
			      long *freed);
#endif				/* WIN32 */

#endif				/* __OPTIONS_H */
