/* htab.h - Structures and declarations needed for table hashing */

#ifndef __HTAB_H
#define __HTAB_H

#include "config.h"
#include "mushdb.h"
#include "confmagic.h"

typedef struct hashentry HASHENT;
struct hashentry {
  char *target;
  void *data;
  struct hashentry *next;
};

typedef struct num_hashentry NHSHENT;
struct num_hashentry {
  int target;
  int *data;
  struct num_hashentry *next;
};

typedef struct hasharray HASHARR;
struct hasharray {
  HASHENT *element[500];
};

typedef struct num_hasharray NHSHARR;
struct num_hasharray {
  NHSHENT *element[500];
};

typedef struct hashtable HASHTAB;
struct hashtable {
  int hashsize;
  int mask;
  int checks;
  int scans;
  int max_scan;
  int hits;
  int entries;
  int deletes;
  int nulls;
  HASHARR *entry;
  int last_hval;		/* Used for hashfirst & hashnext. */
  HASHENT *last_entry;		/* like last_hval */
};

typedef struct num_hashtable NHSHTAB;
struct num_hashtable {
  int hashsize;
  int mask;
  int checks;
  int scans;
  int max_scan;
  int hits;
  int entries;
  int deletes;
  int nulls;
  NHSHARR *entry;
};

typedef struct name_table NAMETAB;
struct name_table {
  char *name;
  int minlen;
  int perm;
  int flag;
};

#define nhashinit(h,s) hashinit((HASHTAB *)h, s)
#define nhashreset(h) hashreset((HASHTAB *)h)
#define nhashinfo(t,h) hashinfo(t,(HASHTAB *)h)

extern int hashval _((const char *str, int hashmask));
extern int get_hashmask _((int *size));
extern void hashinit _((HASHTAB * htab, int size));
extern void hashreset _((HASHTAB * htab));
extern void *hashfind _((const char *str, HASHTAB * htab));
extern int hashadd _((const char *str, void *hashdata, HASHTAB * htab));
extern void hashdelete _((char *str, HASHTAB * htab));
extern void hashflush _((HASHTAB * htab, int size));
extern int hashrepl _((char *str, void *hashdata, HASHTAB * htab));
extern void hashfree _((HASHTAB * htab));
extern char *hashinfo _((const char *tab_name, HASHTAB * htab));
extern void *hash_firstentry _((HASHTAB * htab));
extern void *hash_nextentry _((HASHTAB * htab));
extern void *nhashfind _((int val, NHSHTAB * htab));
extern int nhashadd _((int val, int *hashdata, NHSHTAB * htab));
extern void nhashdelete _((int val, NHSHTAB * htab));
extern void nhashflush _((NHSHTAB * htab, int size));
extern int nhashrepl _((int val, int *hashdata, NHSHTAB * htab));
#endif
