/* chat.h */

#ifndef __CHAT_H
#define __CHAT_H

#include "conf.h"

#if (CHAT_SYSTEM >= 2)

#include "mushdb.h"
#include "externs.h"

extern void channel_broadcast _((channel_type channel, const char *fmt,...));
extern void do_channel_who _((dbref player, channel_type chan));
extern int nchan _((channel_type channel));

#define Channels(x)   (db[(x)].channels)

typedef struct chat_entry CHTAB;

struct chat_entry {
  char *name;
  int perms;
  int quiet;
};

extern CHTAB chantab[];

/* channel permissions */
#define CHP_FORBID   0x0
#define CHP_PUBLIC   0x1
#define CHP_ADMIN    0x2
#define CHP_WIZARD   0x3
#ifdef OBJECT_CHAT
#define CHP_OBJECT   0x4
#endif
#define CHP_MASK     0x7

/* channel permission macros */
#define ChanPrivs(c)   (chantab[nchan(c)].perms & CHP_MASK)
#define NChanPrivs(c)  (chantab[(c)].perms & CHP_MASK)

/* is player x listening to channel c? */
#define OnChannel(x,c) (db[(x)].channels & c)

/* macro to determine if player x can listen or speak to channel c */
#ifdef OBJECT_CHAT
#define ChannelPermit(x,c)  (((ChanPrivs(c) == CHP_PUBLIC) && \
			      (Typeof(x) == TYPE_PLAYER)) || \
			     OnChannel(x, c) || \
			     Wizard(x) || \
			     ((ChanPrivs(c) == CHP_ADMIN) && \
			      (Hasprivs(x) || (Powers(x) & CHAT_PRIVS))) || \
			     ((ChanPrivs(c) == CHP_OBJECT) && \
			      (Typeof(x) == TYPE_THING)))

#else
#define ChannelPermit(x,c)  ((ChanPrivs(c) == CHP_PUBLIC) || \
			     OnChannel(x, c) || \
			     Wizard(x) || \
			     ((ChanPrivs(c) == CHP_ADMIN) && \
			      (Hasprivs(x) || (Powers(x) & CHAT_PRIVS))))
#endif

/* name of channel */
#define channel_name(c)     (chantab[nchan(c)].name)
#define NChanName(c)   (chantab[(c)].name)

/* is a channel quiet? */
#define QuietChan(c)   (chantab[nchan(c)].quiet)
#define QuietNChan(c)  (chantab[(c)].quiet)

#endif				/* CHAT_SYSTEM */

#endif				/* __CHAT_H */
