/*
** id_query.c                             Transmit a query to an IDENT server
**
** Author: Peter Eriksson <pen@lysator.liu.se>
** Slight modifications by Alan Schwartz
*/

#include "config.h"

#ifdef NeXT3
#  include <libc.h>
#endif

#include <stdio.h>
#include <errno.h>
#include <signal.h>

#ifdef I_SYS_TYPES
#include <sys/types.h>
#endif
#ifdef I_SYS_WAIT
#include <sys/wait.h>
#endif
#ifdef I_SYS_TIME
#include <sys/time.h>
#endif

#include "ident.h"

#include "confmagic.h"

int id_query _((ident_t *id, int lport, int fport, __STRUCT_TIMEVAL_P timeout));
int id_query
#ifdef CAN_NEWSTYLE
    (ident_t *id, int lport, int fport, __STRUCT_TIMEVAL_P timeout)
#else
    (id, lport, fport, timeout)
ident_t *id;
int lport;
int fport;
__STRUCT_TIMEVAL_P timeout;
#endif
{
    Signal_t (*old_sig)();
    int res;
    char buf[80];
    fd_set ws;
    
    sprintf(buf, "%d , %d\r\n", lport, fport);
    
    if (timeout)
    {
	FD_ZERO(&ws);
	FD_SET(id->fd, &ws);
	
	if ((res = select(FD_SETSIZE,
			  (fd_set *)0, &ws,
			  (fd_set *)0,
			  timeout)) < 0)
	    return -1;
	
	if (res == 0)
	{
	    errno = ETIMEDOUT;
	    return -1;
	}
    }

    old_sig = signal(SIGPIPE, SIG_IGN);
    
    res = write(id->fd, buf, strlen(buf));
    
    signal(SIGPIPE, old_sig);
    
    return res;
}
