/*--------------------------------------------------------------------*
 * dune.h - DuneMUSH source modification options                      *
 * Nearly all code compiled in by these options was written by        *
 * Alan Schwartz (Javelin, Paul@DuneMUSH, alansz@cogsci.berkeley.edu) *
 *                                                                    *
 * Please read all the options carefully. They are separated into the *
 * following categories:                                              *
 *  SECURITY - options relating to MUSH security                      *
 *  DB       - options which modify the MUSH db structure             *
 *  DUMP     - options which relate to MUSH dump behavior             *
 *  HELP     - options which relate to MUSH text files                *
 *  COMMAND  - options which add or modify MUSH commands              *
 *  FUNCTION - options which add or modify MUSH functions             *
 *  FLAG     - options which add or modify MUSH flags, powers, attrs  *
 *  LOCKS    - options which add or modify MUSH locks                 *
 *  COSMETIC - options which change how various things look to users  *
 *  MISC     - miscellaneous stuff which doesn't fit elsewhere        *
 * My recommendations are noted for some of the options. :)           *
 *                                                                    *
 * To define an option, remove the '/*' in front of the #define.      *
 * To undefine an option, add a '/*' in front of the #define.         *
 *--------------------------------------------------------------------*/


#ifndef __DUNE_H
#define __DUNE_H

/*--------------------------- SECURITY -------------------------------*/

/* If defined, Guest players may not @link, @set, or set attribs.
 * Highly recommended.
 */
#define HARSH_GUEST /* */

/* If defined, only roy/wiz/see_all players can see other players' powers */
#define HASPOWER_RESTRICTED /* */

/* If defined, enables the @sitelock command, which allows Wizards to
 * add sites to the sites.conf file on-the-fly, and allows God to use
 * @sitelock/ban, and add to the lockout.conf file on the fly. Recommended.
 */
#define SITELOCK_COMMAND /* */


/*------------------------------ DB ----------------------------------*/

/* If defined, enables Ralph Melton's @lock rewrite, which allows
 * many more types of locks with less memory usage.
 * Highly recommended. If you use this, see the LOCK section later.
 */
#define RALPH_LOCKS /* */

/* If defined, enables the MUSH Building Warning system, which checks
 * for various building problems at a configurable interval or at
 * a player's request. Pretty neat stuff. Will typically add 4 bytes to each
 * object in memory. Recommended.
 */
#define USE_WARNINGS /* */

/* If defined, enables tracking of creation times for all objects,
 * attribute modification times for non-player objects,
 * and number of login failures for player objects.
 * Will typically add 8 bytes to each object in memory
 * Tracking login failures and modification times is a good security
 * measure, too. Also enables the ctime() and mtime() functions.
 * On the whole, recommended unless you're really pinched for memory
 * (i.e., for a 10,000 object db, you can't afford using another 80kb)
 *
 */
#define CREATION_TIMES /* */

/*----------------------------- DUMP ---------------------------------*/

/* If defined, 1 minute and 5 minute warnings will be given before
 * non-forking dumps. Highly recommended.
 */
#define DUMP_WARNINGS /* */


/*----------------------------- HELP ---------------------------------*/

/* If defined, enables the "index" command, which works just like
 * help, news, and events, and which, together with the script
 * "txtindex" (at ftp://pennmush.tinymush.org/pub/DuneMUSH/Scripts)
 * allows your players to read keyword-generated indexes to the other
 * text files
 */
#define INDEX_COMMAND /* */
#ifdef INDEX_COMMAND
#define INDEX_FILE	"txt/index.txt"
#define INDEXINDX	"txt/index.indx"
#endif

/* If defined, creates a new command, 'rules', which works just like
 * help, news, and events.
 */
#define RULES /* */
#ifdef RULES
#define RULES_FILE	"txt/rules.txt"
#define RULESINDX	"txt/rules.indx"
#endif


/*---------------------------- COMMAND -------------------------------*/

/* Dune's extended @mail system, described in extmail.c.
 * This will not increase the size of your maildb or anything nasty.
 * The maildb under extended mail can be used with normal mail, and vice versa
 * Try it, you'll like it!
 */
#define EXTENDED_MAIL /* */

/*
 * Defining MAIL_SUBJECTS adds subject lines to @mail. This modifies
 * the maildb format, but you can reverse it.
 */
#define MAIL_SUBJECTS /* */

/* Defining ALLOW_NOSUBJECT (which only applies if EXTENDED_MAIL and
 * MAIL_SUBJECTS are defined) marks mail sent with no subject as having
 * subject '(no subject)'. The default is for the subject of the mail
 * to be the first 30 characters of the message when not specfied
 */
#define ALLOW_NOSUBJECT /* */

/* If defined, the @dest command is renamed @recycle (@rec)
 * Why do I hate @dest? Because it's too close to @desc... :P
 * Recommended.
 */
#define HATE_DEST /* */

/* If defined, the @toad command is disabled. Wizards shouldn't @toad,
 * they should @newpassword and tell God. God shouldn't waste time
 * using @toad, and should just @nuke the player.
 * Idea by Kenric@DuneII
 */
#define HATE_TOAD /* */

/* If defined, disables the 'kill' command, admonishing players to use
 * the IC combat system instead. The wizard command slay is still enabled
 */
/* #define NO_KILL /* */

/* If defined, whisper defaults to whisper/noisy. That means that
 * people in the room will see a "Broncalo whispers to Paul." message.
 * Applies to whisper-poses, too, but not to admin long-distance
 * whispering. Players can still use whisper/silent for the other
 * behavior.
 */
/* #define NOISY_WHISPER /* */

/* If this is defined, possessive get is enabled (get player's object),
 * as is standard on PennMUSH. Some may prefer to disable it.
 */
#define POSSESSIVE_GET /* */

/* If this is defined, possessive get is allows on disconnected players,
 * which is standard in PennMUSH. Many may prefer to disable this.
 */
#define POSSGET_ON_DISCONNECTED /* */

/* If defined, the command 'read' is a synonym for 'look'. If not,
 * people can use it as a user-defined command. Not recommended.
 */
/* #define READ /* */

/* If defined, the SAFE flag blocks any attempt to destroy an object.
 * Anyone who has the privileges to destroy the object can set it !safe,
 * anyway.
 */
#define REALLY_SAFE /* */

/* If defined, only royalty can use the @find command. Why?
 * Mortals shouldn't use it, because it's expensive, and @search is better
 * Wizards shouldn't use it, because it shows them the whole db
 * That leaves royalty as possible users.
 */
/* #define ROY_FIND /* */

/* If defined, when a player is destroyed, any objects he owns that are
 * not set SAFE are destroyed, and any objects he owns that are set SAFE
 * are @chowned to God. If this is not defined, all possessions of a player
 * are chowned to God when the player is destroyed.
 */
#define DESTROY_POSSESSIONS /* */


/*---------------------------- FUNCTION ------------------------------*/

/* If defined, the encrypt() and decrypt() functions are enabled */
#define CRYPTFUNS /* */

/* If defined, the shl(), shr(), inc(), and dec() functions are added
 * That's bitshift left, right, increment by 1 and decrement.
 */
#define LOWER_MATH /* */

/* If defined, the objmem() and playermem() functions are added, which
 * return memory usage for an object or all a player's objects.
 */
#define MEMORY_FUNS /* */

/* If this is defined, the lparent() function is available.
 * lparent(<obj>) returns a list of <obj> and all its ancestors
 * (via @parent) which the player is priv'd to see.
 */
#define LPARENT_FUNCTION /* */

/* TinyMUSH 2.2 uses atoi in boolean logic functions. That is, any
 * string (or db#) evaluates to 0 (false).
 * PennMUSH has traditionally used a function which makes strings and
 * db#'s which are larger than #0 return true.
 * If you want Tiny 2.2 compatibility in and(), or(), not(), define this
 * It may break existing code.
 */
/* #define TINY22_BOOLEANS /* */

/* If defined, adds vector arithmetic functions: vadd, vsub, vmul, vmag,
 * vdim, vunit
 */
#define VECTORS /* */


/*------------------------------ FLAG --------------------------------*/

/* The &adest attrib will be triggered when an object is nuked if this
 * is defined.
 */
#define ADEST_ATTRIB /* */

/* The &amail attrib will be triggered when a player received @mail,
 * with sender as %#, if this is defined. It's currently restricted
 * to roy/wiz only, since it does no checking for mail loops!
 */
/* #define AMAIL /* */

/* The fixed flag, when set on a player, prevents the player or anything
 * they own from using @tel or home (roy/wizzes exempted from @tel restriction)
 * Nice for enforcing IC travel. :)
 * The only exception is that players are permitted to @tel their objects
 * to their inventory - which makes coding puppets to follow you possible.
 */
#define FIXED_FLAG /* */

/* If defined, enables the Jury and Judge flags, which don't do anything
 * in themselves, but which other MUSHes may find useful
 */
/* #define JURY_OK /* */

/* If defined, adds support for the UNREGISTERED flag, which you can
 * arrange in mush.conf to have set on new players, and can test for.
 * The only hardcoded restriction is in wiz.c - unreg'd players can't
 * be given powers
 */
#define ONLINE_REG /* */

/* If defined, adds support for the ON_VACATION flag, which a player
 * can set to indicate that they're going to be away from the MUSH
 * for vacation (and which a wizard can test for when doing player purges,
 * or which can aid other players, etc). This flags is automatically
 * cleared when a player logs in, so it should be set just before the
 * player leaves for vacation
 */
#define VACATION_FLAG /* */

/* If this is defined, and PLAYER_LISTEN is defined, players may have
 * @listens (for example *, so their contents can hear things), but
 * can't have @ahears.
 */
/* #define PLAYER_NOAHEAR /* */

/* If defined, @aconnect/@adisconnect in rooms will be triggered for
 * players connecting/disconnecting therein
 */
#define ROOM_CONNECTS /* */

/* If defined, adds the UNINSPECTED flag for rooms, which does nothing,
 * but can be tested for in mushcode, etc.
 */
#define UNINSPECTED_FLAG /* */

/*------------------------------ LOCK --------------------------------*/

/* If defined, @lock/listen sets a lock which controls who can trigger
 * ^patterns and @ahears on the thing.
 */
#define LISTEN_LOCK /* */

/* If defined, @lock/speech sets a lock which controls who can
 * speak/pose/emit in a room.
 */
#define SPEECH_LOCK /* */

/* If defined, @lock/leave sets a lock which controls who can
 * leave an object
 */
#define LEAVE_LOCK /* */

/* If defined, @lock/drop sets a lock which controls who can drop
 * an object.
 */
#define DROP_LOCK /* */

/* If defined, @lock/give sets a lock which controls who can
 * give away an object
 */
#define GIVE_LOCK /* */

/*---------------------------- COSMETIC ------------------------------*/

/* If defined, object/room/player names will appear bold. Requires
 * EXTENDED_ANSI to be defined in order to work. Recommended. */
#define ANSI_NAMES /* */

/* If defined, the count of players on the WHO list will include
 * Dark/Hidden players not visible on the list
 */
/* #define COUNT_ALL /* */

/* If defined, rooms which have at least one exit are not considered
 * "disconnected rooms" and do not need to be set FLOATING.
 * If not defined, the traditional definition of a connected room
 * (a room which can be reached from #0) is used.
 */
/* #define EXITS_CONNECT_ROOMS /* */

/* These are defined as the prefixes which prepend @wizwall, @rwall,
 * and @wall messages. You can change them as you like.
 * Idea by Aragorn@ElendorMUSH
 */
#define WIZWALL_PREFIX	"Broadcast:"
#define RWALL_PREFIX	"Admin:"
#define WALL_PREFIX	"Announcement:"


/*------------------------------ MISC --------------------------------*/

/* What type of attribute compression should the MUSH use?
 * Your options are:
 * 1 - the default Huffman compression which has been in use since
 *     pl10. In theory, this should be the best compression,
 *     possibly at the cost of some speed. Sometimes has trouble
 *     on linux systems for some reason.
 * 2 - the bigram compression from pl9 and earlier (but autotuned)
 *     This should be intermediate in compression and speed, and
 *     and at least one database that won't load under Huffman,
 *     will load under bigram. Use if Huffman won't work.
 * 0 - No compression at all. Very fast, but your db in memory
 *     will be big - at least as large as your on-disk db.
 *     Possibly suitable for the building stages of a small MUSH.
 * You can change this at any time, with no worries. It only affects
 * the in-memory compression of attribute/mail text, not the disk
 * db compression. Recommend to keep it at 1.
 */
#define COMPRESSION_TYPE	1

/* If defined, one may only @link to rooms, not to link_ok objects.
 * This makes link_ok on objects function purely as parent_ok.
 */
/* #define NO_LINK_TO_OBJECT /* */

/* If defined, adds support for a new kind of chat channel, object-channels.
 * Only objects (and wizards) may join these channels. Useful for
 * radio systems, etc., though it can be computationally expensive.
 * Not recommended unless you have an important application.
 * Does not apply to the extended chat system
 */
/* #define OBJECT_CHAT /* */

/* If defined, queue limits are maintained on a per-owner basis,
 * instead of a per-object basis. That is, your object is runaway
 * when your total queue goes too high, not when that object's
 * queue does.
 */
/* #define QUEUE_PER_OWNER /* */

/* If defined, DARK wizards don't trigger AENTER/ALEAVE as they move around */
#define WIZ_NOAENTER /* */


#endif /* __DUNE_H */
