/* mkindx.c */

#ifdef WIN32

#include  <stdio.h>
#include  <stdlib.h>
#include "config.h"
#include "conf.h"
#include  "help.h"
#include "confmagic.h"
#include <string.h>

#define TRUE    1
#define FALSE   0

typedef struct TLIST {
  char topic[TOPIC_NAME_LEN + 1];
  struct TLIST *next;
} tlist;
tlist *top = NULL;


void write_topic _((FILE * out, long int p, int l));
static void add_topic _((char *name));

void
write_topic(out, p, l)
    FILE *out;
    long int p;
    int l;
{
  tlist *cur, *nextptr;
  help_indx temp;
  for (cur = top; cur; cur = nextptr) {
    nextptr = cur->next;
    temp.pos = p;
    temp.len = l;
    strcpy(temp.topic, cur->topic);
    if (fwrite(&temp, sizeof(help_indx), 1, out) < 1) {
      fprintf(stderr, "error writing\n");
      exit(-1);
    }
    free(cur);
  }
  top = NULL;
}

static void
add_topic(name)
    char *name;
{
  tlist *cur;
  cur = (tlist *) malloc(sizeof(tlist));
  strcpy(cur->topic, name);
  cur->next = top;
  top = cur;
}

char line[LINE_SIZE + 1];
int
makeindex (const char * inputfile, const char * outputfile)
{
  long bigpos, pos = 0;
  int in_topic;
  int i, n, lineno, ntopics;
  char *s, *topic;
  char the_topic[TOPIC_NAME_LEN + 1];
  FILE *rfp, *wfp;

  if ((rfp = fopen(inputfile, "rb")) == NULL) {
    fprintf(stderr, "can't open %s for reading\n", inputfile);
    exit(-1);
  }
  if ((wfp = fopen(outputfile, "wb")) == NULL) {
    fprintf(stderr, "can't open %s for writing\n", outputfile);
    exit(-1);
  }

  fprintf (stderr, "Indexing file %s\n", inputfile);

  bigpos = 0L;
  lineno = 0;
  ntopics = 0;

  in_topic = FALSE;

  while (fgets(line, LINE_SIZE, rfp) != NULL) {
    ++lineno;

    n = strlen(line);
    if (line[n - 1] != '\n') {
      fprintf(stderr, "line %d: line too long\n", lineno);
    }
    if (line[0] == '&') {
      ++ntopics;
      if (!in_topic) {
        /* Finish up last entry */
        if (ntopics > 1) {
          write_topic(wfp, pos, bigpos - pos);
        }
        in_topic = TRUE;
      }
      /* parse out the topic */
      /* Get the beginning of the topic string */
      for (topic = &line[1];
           (*topic == ' ' || *topic == '\t') && *topic != '\0'; topic++) ;

      /* Get the topic */
      strcpy(the_topic, "");
      for (i = -1, s = topic; *s != '\n' && *s != '\0'; s++) {
        if (i >= TOPIC_NAME_LEN - 1)
          break;
        if (*s != ' ' || the_topic[i] != ' ')
          the_topic[++i] = *s;
      }
      the_topic[++i] = '\0';
      add_topic(the_topic);
    } else {
      if (in_topic) {
        pos = bigpos;
      }
      in_topic = FALSE;
    }
    bigpos = ftell (rfp);
  }

  /* Handle last topic */
  write_topic(wfp, pos, bigpos - pos);
  fclose(rfp);
  fclose(wfp);

  fprintf(stderr, "    %d topics indexed\n", ntopics);

  return 0;
}


#endif  /* WIN32 */
