/* Win32 memory allocation statistics routines */

/* Author: Nick Gammon */

#ifdef WIN32

#include "copyrite.h"
#include "config.h"

#ifdef I_STDLIB        
#include <stdlib.h>   
#endif 
#include <malloc.h>

#include "conf.h"
#include "mushdb.h"
#include "intrface.h"
#include "match.h"
#include "externs.h"
#include "confmagic.h"


/* These must appear AFTER the includes, so as to undefine our
   "interim" routines
*/

#undef malloc
#undef calloc
#undef realloc
#undef free

#define SLONG sizeof (long)

static long malloc_count = 0,
            free_count = 0,
            total_mallocked = 0,
            total_freed = 0;

void *Win32_malloc( size_t size )
    {
void * p = malloc (size);

    if (p)
        {
        malloc_count ++;
        total_mallocked += _msize (p);
        }

    return p;
    }

void *Win32_realloc(void * memblock, size_t size )
    {
void * p;

    if (memblock)
        {
        total_freed += _msize (memblock);
        free_count ++;
        }

    p = realloc (memblock, size);

    if (p)
        {
        malloc_count ++;
        total_mallocked += _msize (p);
        }

    return p;
    }

void *Win32_calloc( size_t num, size_t size )
    {
long totalsize = size * num;

void * p = calloc (num, size);

    if (p)
        {
        malloc_count ++;
        total_mallocked += _msize (p);
        }

    return p;

    }

void Win32_free( void *memblock )
    {

/* Do not attempt to free a nil pointer */

    if (!memblock)
        return;

    total_freed += _msize (memblock);
    free_count ++;

    free (memblock);
    }


void Win32_return_memory_used (long * mallocs, 
                               long * frees, 
                               long * allocated,
                               long * freed)
    {
    *mallocs    = malloc_count;
    *frees      = free_count;
    *allocated  = total_mallocked;
    *freed      = total_freed;
    }

#endif  
