/* options.h */

#ifndef __OPTIONS_H
#define __OPTIONS_H

/* *********** READ THIS BEFORE YOU MODIFY ANYTHING IN THIS FILE *********** */
/* WARNING:  All options in this file have the ability to signifigantly change
 * the look and feel and sometimes even internal behavior of the program.
 * The ones shipped as the default have been extensively tested.  Others have
 * been tested to a (usually) lesser degree, and therefore might still have
 * latent bugs.  If you change any of them from the default, PLEASE check
 * to make sure that you know the full effects of what you are changing. And
 * if you encounter any errors or compile time problems with any options
 * other than the default settings, inform dunemush@pennmush.tinymush.org
 * immediately, so that they can be fixed.  The same goes for any other bug
 * you might find in using this software.  All efforts will be made to fix
 * errors encountered, but unless given a FULL description of the error,
 * (IE telling me that logging in doesn't work is insufficient.  telling
 * me that logging in with WCREAT undefined still gives you the registration
 * message is a lot better.  MOST effective would be a full dbx trace, or a
 * patch for the bug.)  Enjoy using the program.
 */
/* ************************************************************************* */

/* This configuration file is divided into three sections:
 *
 *   1. Major MUSH options.
 *   2. MUSH configuration options.
 *   3. Constants and other definitions.
 *
 */


/*--------------------------------------------------------------------------
 * Major MUSH options.
 */

/* This allows extended ANSI codes to be used in functions. This also
 * results in the game having to filter output for ANSI codes; only
 * define this if you're not worried about CPU usage.
 * This also enables the COLOR flag and the FORCE_WHITE flag.
 */
#define EXTENDED_ANSI /* */

/* This allows floating point operations. If you are on a very slow
 * system, you might not wish to define this. It also makes the server
 * somewhat larger. Define this if you find it useful.
 */
#define FLOATING_POINTS /* */

/* This option is to control whether functions may have side effects
 * affecting the db.  With it on, the functions create(), open(),
 * dig(), link(), and set() exist, corresponding to the @commands of
 * the same name.  Also, the 2 parameter versions of zone(), parent(),
 * and lock() are enabled by this define.
 */
/* #define FUNCTION_SIDE_EFFECTS /* */

/* This option controls whether or not player names can have spaces in
 * them. "Traditionally", this option is off.
 */
/* #define PLAYER_NAME_SPACES /* */

/* Define the following if you are running on a machine so small that you
 * cannnot fork a process off to do the save.
 */
#define NO_FORK /* */

/* Define this if you don't wish your log file to be split up into several
 * components. This saves on file descriptors and makes it easy to tail -f
 * the log, but is inconvenient for quick scanning.
 */
/* #define SINGLE_LOGFILE /* */

/* Comment this out if you don't wish to use the built-in mail system.
 * The @mail command provides a flexible hardcoded mail system, which
 * uses its own database to store messages.
 */
#define USE_MAILER /* */

/*  The chat channels system allows players to talk cross-MUSH to each
 *  other, without needing to be in the same room. Whether or not you
 *  want this depends on what type of MUSH you want. Set the value of
 *  CHAT_SYSTEM to one of the following, depending on what you want:
 *    0  -- do not use chat system
 *    3  -- use original PennMUSH chat system
 *    4  -- use extended comsys chat system
 *  The server will automatically convert db's w/o chat to add chat
 *  or remove chat from db's w/chat, as needed; unlike earlier versions
 *  of the server, you do not need to startup, shutdown, recompile, restart.
 */
#define CHAT_SYSTEM	4

/* If this is defined, another file similar to News and Help can be used
 * to store text, retrieved with "events <whatever>". This is useful if
 * your newsfile is starting to get huge and kludgy.
 */
/* #define EVENTS /* */

/* If this is defined, the clock will be displayed in 24-hour "military time"
 * format. Otherwise, some functions (such as the idle message for 'page')
 * will return 12-hour time.
 */
#define MILITARY_TIME /* */

#ifdef USE_SMALLOC
/* Define the following ONLY if using SMALLOC.C, and if you want accurate
 * malloc stats.
 */
/* #define SLOW_STATISTICS /* */
#endif /* USE_SMALLOC */

/* Defining this adds a simple tracking allocator of allocs and frees that
 * keeps ref counts of what sort of memory is allocated, and how many.
 * Good for testing for Memory leaks. Don't, however, define this unless
 * 1. It's really necessary.  2. You know what you're doing.
 */
/* #define MEM_CHECK /* */


/*--------------------------------------------------------------------------
 * MUSH configuration options
 */

/* Define this if you want the ability to lock out certain sites.  This code
 * will take wildcards. Sites to lock out should be put in lockout.cnf
 * Sites to put on registration status should be in sites.cnf
 * If you define this, you will also need to define WCREAT.
 */
#define LOCKOUT /* */

/* Define this if you want to enable registration commands. If LOCKOUT
 * is defined, this should be too. Running with both this and LOCKOUT
 * defined will allow you to register certain sites. Running with this
 * but not LOCKOUT puts all sites on registration status.
 */
#define WCREAT /* */

/* Define this if you want to limit the maximum number of logins to the
 * MUSH. This is useful if you know that you have a certain peak number
 * before the MUSH freezes (which happens if you run out of file descriptors)
 * or if you're running under a max-number-of-players restriction.
 */
#define LOGIN_LIMIT /* */

/* Define the following if you want an inactivity timeout - the game
 * will automatically boot players who idle too long.
 */
#define IDLE_TIMEOUT /* */

/* One method of slowing bloat.  This method requires all builders to have
 * a builder bit to build.
 */
/* #define RESTRICTED_BUILDING /* */

/* Define the following if you wish to allow object building.  Only useful
 * if RESTRICTED_BUILDING is defined.
 */
/* #define FREE_OBJECTS /* */

/* An alternate method of slowing bloat.  This allows builders only X objects
 * period.  Wizards can check and set quotas on players.  If used in
 * conjunction with RESTRICTED_BUILDING, expect VERY slow growth.
 */
/* #define QUOTA /* */

/* Define this ONLY if you have a small maximum database size, and are
 * about to reach it. This will limit the number of objects allowed to
 * whatever number you set as DBTOP_MAX (defined later in this file).
 * Even wizards are subject to this maximum.
 */
/* #define BUILDING_LIMIT /* */

/* Define this if you wish to allow players to steal money from each other */
#define ROBBERS /* */

/* Defining the following will show an expanded flag name list when you
 * examine an object
 */
#define FLAGS_ON_EXAMINE /* */

/* Defining this will show public attributes on examination of an object
 * that a player doesn't own. (Like "examine/full" in TinyMUSH 2.0)
 */
#define EX_PUBLIC_ATTRIBS /* */

/* Defining this will output attributes in TinyMUSH 2.0 format - i.e.
 * "FOO(#4v): test" instead of "FOO [#4v]: test",  no attribute owners
 * displayed unless different from the owner of the object, etc.
 */
/* #define TINY_ATTRS /* */

/* Define the following for increased wizard invisibility.  If it's enabled,
 * says and poses by DARK wizards will show up as 'Someone ....'
 * pages are not affected.
 */
#define FULL_INVIS /* */

/*  Define this if you want @listen/@ahear/@aahear/@amhear to work on
 *  players as well as objects.
 */
#define PLAYER_LISTEN /* */

/* Define this if you do not want @pemit to notify the person doing the
 * @pemitting (2.0-style).
 */
/* #define SILENT_PEMIT /* */

/*
 * Define the following to enable the ROYALTY flag.  Players with
 * this flag set have limited wiz powers: ie, they can look, examine,
 * and @tel like wizards, but may not change things like wizards.
 */
#define ROYALTY_FLAG /* */

/* Define the following to enable @whereis commands, and loc() on players
 * by other players.  Both of these commands are modified by the effect
 * of the PLAYER_UNFIND flag.
 */
#define PLAYER_LOCATE /* */

/* Define the following if you wish to enable global exits and commands.
 * Exits in the Master Room are considered global, as are user-defined
 * $commands on objects in the Master Room.
 */
#define DO_GLOBALS /* */

/* If this is defined, the zone of a player's location will be checked for
 * an ACONNECT/ADISCONNECT attribute when the player connects/disconnects.
 * If DO_GLOBALS is also defined, the master room will also be checked
 * for an ACONNECT/ADISCONNECT.
 */
#define GLOBAL_CONNECTS /* */

/* Comment this out if you wish to run without the INHERIT flag. This
 * flag prevents objects without it from @forcing, @setting, or
 * @triggering objects with the flag, or with a wizbit. This makes doing
 * secure objects much easier. However, it can make programming certain
 * objects somewhat clumsy, and may cause some initial confusion and
 * frustration when first used on a MUSH not used to it.
 */
#define INHERIT_FLAG /* */

/* Define this if you want NOSPOOF notification to show both the name of
 * the spoofing object and its object number. If this option is not
 * defined, nospoof notification will only show the name of the spoofer.
 */
/* #define PARANOID_NOSPOOF /* */

/* Objects which are NO_COMMAND are not checked for $commands. You can
 * speed up your server somewhat this way. If you want to make the best
 * use of this flag, define this option, which will automatically set
 * the NO_COMMAND flag on all rooms and players in your current database.
 */
/* #define ADD_NO_COMMAND_FLAG /* */

/* This option uses the old method of coping with newlines.
 * If you're converting from a database that might have hard newlines,
 * load with this defined and do a "@dump/paranoid". Otherwise, ignore it.
 */
/* #define OLD_NEWLINES /* */

/*---------------------------------------------------------------------------
 * Constants and other good things.
 */

/*----- default files -----*/

/* The format for the three following files is one site or name per
 * line in the file. These files may be modified at any time, including
 * while the MUSH is running.
 */

#ifdef LOCKOUT
/* sites in the lockout file will have connections shut down immediately
 * with no message. Sites in the register file will not be able to
 * create new players. Wildcards are allowed.
 */
#define LOCKOUT_FILE	"lockout.cnf"
#define REGISTER_FILE	"sites.cnf"
#endif                          /* LOCKOUT */

/* these names may not be used as player names. Wildcards are not allowed. */
#define NAMES_FILE	"names.cnf"

/*----- log files -----*/

/* The primary log file for the MUSH is defined in the restart script.
 * Checkpoints are written to a separate log, as are connects and
 * disconnects from the game, commands used by wizards, report traces,
 * and player commands. The defaults are listed below.
 */

#define CHECKLOG	"log/checkpt.log"
#define CONNLOG	"log/connect.log"
#define WIZLOG	"log/wizard.log"
#define TRACELOG	"log/trace.log"
#define CMDLOG	"log/command.log"

/*----- Costs, dbref definitions, etc. -----*/

/* Uber-wizard */
#define GOD	((dbref) 1)

/* minimum cost to create various things */
#define OBJECT_COST	10
#define EXIT_COST	1
#define LINK_COST	1
#define ROOM_COST	10
#define QUEUE_COST	10	/* deposit on commands in the queue */
#define QUOTA_COST	1	/* quota cost of building an object */

/* cost for various special commands */
#define FIND_COST	100
#define PAGE_COST	0

/* costs of kill command */
#define KILL_BASE_COST	100	/* prob = expenditure/KILL_BASE_COST */
#define KILL_MIN_COST	10
#define KILL_BONUS	50	/* paid to victim */
#define MAX_ARG	100             /* maximum comma's arguments to function
				/* (like @switch). Probably shouldn't mess. */

#define QUEUE_LOSS	63	/* one command in 16 will cost one penny */
                                /* must be a power of two minus 1 */

#ifdef BUILDING_LIMIT
#define DBTOP_MAX	20000	/* max number of objects in the database */
#endif /* BUILDING_LIMIT */

/* amount of object endowment, based on cost */
#define MAX_OBJECT_ENDOWMENT	100
/* max value a wiz can put on an object */
#define MAX_WIZ_OBJECT_ENDOWMENT	2000

/* amount at which temple stops being so profitable */
#define MAX_PENNIES	100000

/* How deep can indirect locks go? */
#define MAX_DEPTH	10

/* How many generations back can parents go? */
#define MAX_PARENTS	10


/*----- timer.c defines -----*/

/* Note: Don't make times multiples of each other
 * otherwise players will have to wait a long time when
 * two or more events coincide
 */

/* time is in seconds */
#define PURGE_INTERVAL	601	/* fixup free list eveyr 10 minutes */
#define DBCK_INTERVAL	599	/* Check db consistency every 10 minutes */



/*---------------------------------------------------------
 * The dune modifications are here
 */

#include "dune.h"

#endif				/* __OPTIONS_H */
