#!/usr/local/bin/perl
#
# Generate game/txt/hlp/pennvers.hlp from the CHANGES file(s).
# Should be run by Makefile from top-level directory
#
# Usage: mkvershlp game/txt/hlp/pennvers.hlp CHANGES CHANGES.OLD ...
# Most recent file should be first, and files should have changes
# in reverse chronological order.
#
use strict;
use Sort::Versions;
use Text::Wrap;

my $target = shift;
my @sources = @ARGV;
my $verspat = '^Version (\S+) patchlevel (\S+)';
my %patchlevels;

open(OUT,">$target") or die "Unable to open $target\n";
print OUT "& changes\n";
my $really_started = 0;
foreach my $file (@sources) {
  warn "Can't open $file!\n", next unless open(IN,"<$file");
  my $started = 0;
  while (<IN>) {
    if (/$verspat/o) {
      print OUT "& $1p$2\n";
      push @{$patchlevels{$1}}, $2;
      unless ($started) {
        # This is the first one 
        unless ($really_started) {
          print OUT <<'EOP';
This is a list of changes in this patchlevel which are probably of
interest to players. More information about new commands and functions
can probably be gotten via 'help <name of whatever>'.

Information about changes in prior releases can be found under
help topics named for each release (e.g. 'help 1.7.2p30').
A list of the patchlevels associated with each release can
be read in 'help patchlevels'.

EOP
          $really_started = 1;
        }
        $started = 1;
      }
      print OUT;
    } elsif ($started) {
      print OUT;
    } 
  }
  close IN;
}

# Now spew the patchlevels list. Special case for 1.50
$patchlevels{'1.5.0'} = $patchlevels{'1.50'};
delete($patchlevels{'1.50'});
my @versions = reverse sort versions keys %patchlevels;
print OUT "& patchlevels\n";
foreach (@versions) {
  my @pls = sort {$a <=> $b} @{$patchlevels{$_}};
  my $line;
  if ($_ eq "1.5.0") {
    $line = "1.50: ". join(", ",@pls). "\n";
  } else {
    $line = "$_: ". join(", ",@pls). "\n";
  }
  print OUT wrap("","       ",$line);
}

close OUT;


