#ifndef _ATTRIB_H
#define _ATTRIB_H

/* the attribute structure */
struct attr {
  char const *name;		/* name of attribute */
  int flags;
  unsigned char *value;
  dbref creator;
  ATTR *next;
};


/* Stuff that's actually in atr_tab.c */
extern ATTR *aname_hash_lookup(const char *name);
extern int alias_attribute(const char *atr, const char *alias);
extern void do_attribute_access
  (dbref player, char *name, char *perms, int retroactive);
extern void do_attribute_delete(dbref player, char *name);
extern void do_attribute_rename(dbref player, char *old, char *newname);
extern void do_attribute_info(dbref player, char *name);
extern void do_list_attribs(dbref player, int lc);
extern char *list_attribs(void);

/* From attrib.c */
extern int good_atr_name(char const *s);
extern ATTR *atr_match(char const *string);
extern void atr_new_add(dbref thing, char const *atr, char const *s,
			dbref player, int flags);
extern int atr_add(dbref thing, char const *atr, char const *s,
		   dbref player, int flags);
extern int atr_clr(dbref thing, char const *atr, dbref player);
extern ATTR *atr_get(dbref thing, char const *atr);
extern ATTR *atr_get_noparent(dbref thing, char const *atr);
typedef int (*aig_func) (dbref, dbref, const char *, ATTR *, void *);
extern int atr_iter_get(dbref player, dbref thing, char const *name,
			aig_func func, void *args);
extern ATTR *atr_complete_match(dbref player, char const *atr, dbref privs);
extern void atr_free(dbref thing);
extern void atr_cpy(dbref dest, dbref source);
extern char const *convert_atr(int oldatr);
extern int atr_comm_match(dbref thing, dbref player, int type, int end,
			  char const *str, int just_match, char *atrname,
			  char **abp);
extern int do_set_atr
  (dbref thing, char const *atr, char const *s, dbref player, int flags);
extern void do_atrlock(dbref player, char const *arg1, char const *arg2);
extern void do_atrchown(dbref player, char const *arg1, char const *arg2);
extern int string_to_atrflag(dbref player, const char *p);
extern void init_atr_name_tree(void);


/* possible attribute flags */
#define AF_ODARK        0x1	/* OBSOLETE! Leave here but don't use */
#define AF_INTERNAL     0x2	/* no one can see it or set it */
#define AF_WIZARD       0x4	/* Wizard only can change it */
#define AF_NUKED        0x8	/* OBSOLETE! Leave here but don't use */
#define AF_LOCKED       0x10	/* Only creator of attrib can change it. */
#define AF_NOPROG       0x20	/* won't be searched for $ commands. */
#define AF_MDARK        0x40	/* Only wizards can see it */
#define AF_PRIVATE      0x80	/* Children don't inherit it */
#define AF_NOCOPY       0x100	/* atr_cpy (for @clone) doesn't copy it */
#define AF_VISUAL       0x200	/* Everyone can see this attribute */
#define AF_REGEXP       0x400	/* Match $/^ patterns using regexps */
#define AF_CASE         0x800	/* Match $/^ patterns case-sensitive */
#define AF_SAFE         0x1000	/* This attribute may not be modified */
#define AF_STATIC       0x10000	/* OBSOLETE! Leave here but don't use */
#define AF_COMMAND      0x20000	/* INTERNAL: value starts with $ */
#define AF_LISTEN       0x40000	/* INTERNAL: value starts with ^ */
#define AF_NODUMP       0x80000	/* INTERNAL: attribute is not saved */
#define AF_LISTED       0x100000	/* INTERNAL: Used in @list attribs */
#define AF_PREFIXMATCH  0x200000	/* Subject to prefix-matching */

/* external predefined attributes. */
extern ATTR attr[];

/* easy access macros for attributes */
#ifdef NEVER
#define s_Osucc(thing,s) atr_add(thing, "OSUCCESS", (s), (thing), NOTHING)
#define s_Ofail(thing,s) atr_add(thing, "OFAILURE", (s), (thing), NOTHING)
#define s_Fail(thing,s) atr_add(thing, "FAILURE", (s), (thing), NOTHING)
#define s_Succ(thing,s) atr_add(thing, "SUCCESS", (s), (thing), NOTHING)
#define s_Pass(thing,s) atr_add(thing, "XYXXY", (s), GOD, NOTHING)
#define s_Desc(thing,s) atr_add(thing, "DESCRIBE", (s), (thing), NOTHING)

#define Astr(attrib) ((attrib)->value)
#endif

#define AL_ATTR(alist)          (alist)
#define AL_NAME(alist)          ((alist)->name)
#define AL_STR(alist)           ((alist)->value)
#define AL_NEXT(alist)          ((alist)->next)
#define AL_CREATOR(alist)       ((alist)->creator)
#define AL_FLAGS(alist)         ((alist)->flags)

#endif				/* __ATTRIB_H */
