#ifndef BOOLEXP_H
#define BOOLEXP_H
#include "copyrite.h"

/* Boolean expressions, for locks */
typedef enum boolexp_type {
  BOOLEXP_AND,
  BOOLEXP_OR,
  BOOLEXP_NOT,
  BOOLEXP_CONST,
  BOOLEXP_ATR,
  BOOLEXP_IND,
  BOOLEXP_CARRY,
  BOOLEXP_IS,
  BOOLEXP_OWNER,
  BOOLEXP_EVAL,
  BOOLEXP_FLAG
} boolexp_type;

/* tokens for locks */
#define NOT_TOKEN '!'
#define AND_TOKEN '&'
#define OR_TOKEN '|'
#define AT_TOKEN '@'
#define IN_TOKEN '+'
#define IS_TOKEN '='
#define OWNER_TOKEN '$'

struct boolatr {
  const char *name;		/* which attribute? */
  char text[BUFFER_LEN];
};

struct boolexp {
  boolexp_type type;		/* and, or, not, indirect, is, carry, etc. */
  dbref thing;			/* thing refers to an object */
  union {
    struct {
      struct boolexp *a;
      struct boolexp *b;
    } sub;			/* For and and or locks */
    struct boolexp *n;		/* For not locks */
    struct boolatr *atr_lock;	/* For atr, eval and flag locks */
    const char *ind_lock;	/* For indirect locks */
  } data;
};

#define TRUE_BOOLEXP ((struct boolexp *) 0)

/* From boolexp.c */
extern struct boolatr *alloc_atr(const char *name, const char *s);
extern struct boolexp *dup_bool(struct boolexp *b);
extern struct boolexp *alloc_bool(void);
extern int sizeof_boolexp(struct boolexp *b);
extern int eval_boolexp(dbref player, struct boolexp *b, dbref target);
extern struct boolexp *parse_boolexp(dbref player, const char *buf,
				     lock_type ltype);
extern void free_boolexp(struct boolexp *b);
struct boolexp *getboolexp(FILE * f, const char *ltype);
void putboolexp(FILE * f, struct boolexp *b);
enum u_b_f { UB_ALL, UB_DBREF };
extern char *unparse_boolexp(dbref player, struct boolexp *b, enum u_b_f flag);
#endif				/* BOOLEXP_H */
