#ifndef _FUNCTIONS_H_
#define _FUNCTIONS_H_

#include "copyrite.h"

#define FN_REG 0x0
/* Function arguments aren't parsed */
#define FN_NOPARSE      0x1
#define FN_LITERAL      0x2
#define FN_ARG_MASK     0x3
/* Function is disabled */
#define FN_DISABLED     0x4
/* Function will fail if object is gagged */
#define FN_NOGAGGED  0x8
/* Function will fail if object is a guest */
#define FN_NOGUEST   0x10
/* Function will fail if object is fixed */
#define FN_NOFIXED   0x20
/* Function is wizard-only */
#define FN_WIZARD 0x40
/* Function is royalty or wizard */
#define FN_ADMIN  0x80
/* Function is god-only */
#define FN_GOD    0x100
/* Function is builtin */
#define FN_BUILTIN 0x200
/* Function can be overridden with a @function */
#define FN_OVERRIDE 0x400
/* Side-effect version of function no workie */
#define FN_NOSIDEFX 0x800


/* Number of user @functions */
#define MAX_GLOBAL_FNS 50

#ifndef HAVE_FUN_DEFINED
typedef struct fun FUN;
#define HAVE_FUN_DEFINED
#endif

typedef void (*function_func) (FUN *, char *, char **, int, char *[], int[],
			       dbref, dbref, dbref, const char *, PE_Info *);

union fun_call {
  function_func fun;
  Size_t offset;
};


struct fun {
  const char *name;
  union fun_call where;
  int minargs;
  int maxargs;
  unsigned int flags;
};

typedef struct userfn_entry USERFN_ENTRY;

struct userfn_entry {
  char *fn;
  dbref thing;
  char *name;
  unsigned int flags;
};

extern USERFN_ENTRY userfn_tab[MAX_GLOBAL_FNS];

extern void do_userfn(char *buff, char **bp,
		      dbref obj, ATTR *attrib,
		      int nargs, char **args,
		      dbref executor, dbref caller, dbref enactor,
		      PE_Info * pe_info);

extern FUN *func_hash_lookup(const char *name);
extern int check_func(dbref player, FUN *fp);
extern int restrict_function(const char *name, const char *restrict);
extern int alias_function(const char *function, const char *alias);
extern void do_function_restrict(dbref player, const char *name,
				 const char *restrict);
extern void do_function_restore(dbref player, const char *name);
extern void do_list_functions(dbref player, int lc);
extern char *list_functions(void);
extern void do_function(dbref player, char *name, char **argv);
extern void do_function_toggle(dbref player, char *name, int toggle);
extern void do_function_report(dbref player, char *name);
extern void do_function_delete(dbref player, char *name);



#define FUNCTION_PROTO(fun_name) \
  extern void fun_name (FUN *fun, char *buff, char **bp, int nargs, char *args[], \
                   int arglen[], dbref executor, dbref caller, dbref enactor, \
                   char const *called_as, PE_Info *pe_info)
extern void function_add(const char *name, function_func fun, int minargs,
			 int maxargs, int ftype);

#endif
