/* htab.h - Structures and declarations needed for table hashing */

#ifndef __HTAB_H
#define __HTAB_H

#define SOME_KEY_LEN 10

#define HTAB_UPSCALE   4
#define HTAB_DOWNSCALE 2

typedef struct hashentry HASHENT;
struct hashentry {
  struct hashentry *next;
  void *data;
  /* int extra_size; */
  char key[SOME_KEY_LEN];
};

#define HASHENT_SIZE (sizeof(HASHENT)-SOME_KEY_LEN)

typedef struct hashtable HASHTAB;
struct hashtable {
  int hashsize;
  int mask;
  int entries;
  HASHENT **buckets;
  int last_hval;		/* Used for hashfirst & hashnext. */
  HASHENT *last_entry;		/* like last_hval */
  int entry_size;
};

#define hashval(x,y) hash_val(x,y)
#define get_hashmask(x) hash_getmask(x)
#define hashinit(x,y, z) hash_init(x,y, z)
#define hashfind(key,tab) hash_value(hash_find(tab,key))
#define hashadd(key,data,tab) hash_add(tab,key,data, 0)
#define hashadds(key, data, tab, size) hash_add(tab, key, data, size)
#define hashdelete(key,tab) hash_delete(tab,hash_find(tab,key))
#define hashflush(tab, size) hash_flush(tab,size)
#define hashfree(tab) hash_flush(tab, 0)
extern int hash_val(const char *key, int hashmask);
extern int hash_getmask(int *size);
extern void hash_init(HASHTAB *htab, int size, int data_size);
extern HASHENT *hash_find(HASHTAB *htab, const char *key);
extern void *hash_value(HASHENT *entry);
extern char *hash_key(HASHENT *entry);
extern void hash_resize(HASHTAB *htab, int size);
extern HASHENT *hash_new(HASHTAB *htab, const char *key);
extern int hash_add
  (HASHTAB *htab, const char *key, void *hashdata, int extra_size);
extern void hash_delete(HASHTAB *htab, HASHENT *entry);
extern void hash_flush(HASHTAB *htab, int size);
extern void *hash_firstentry(HASHTAB *htab);
extern void *hash_nextentry(HASHTAB *htab);
extern void hash_stats_header(dbref player);
extern void hash_stats(dbref player, HASHTAB *htab, const char *hashname);
#endif
