#ifndef MUSH_TYPES_H
#define MUSH_TYPES_H
#include "copyrite.h"
#include "options.h"
#include <stdio.h>
/* Function number type */
typedef double NVAL;

/* Dbref type */
typedef int dbref;

/* special dbref's */
#define NOTHING (-1)		/* null dbref */
#define AMBIGUOUS (-2)		/* multiple possibilities, for matchers */
#define HOME (-3)		/* virtual room, represents mover's home */
#define ANY_OWNER (-2)		/* For lstats and @stat */


typedef int object_flag_type;

/* Boolexps and locks */
struct boolexp;
typedef const char *lock_type;
typedef struct lock_list lock_list;

/* This type is used by process_expression().  In all but parse.c,
 * this should be left as an incompletely-specified type, making it
 * impossible to declare anything but pointers to it.
 */
/* Unfortunately, we need to know what it is in funlist.c, too,
 * to prevent denial-of-service attacks.  ARGH!  Don't look at
 * this struct unless you _really_ want to get your hands dirty.
 */

typedef struct pe_info PE_Info;
typedef struct debug_info Debug_Info;
struct pe_info {
  int fun_invocations;
  int fun_depth;
  int nest_depth;
  int call_depth;
  Debug_Info *debug_strings;
};


/* new attribute foo */
typedef struct attr ATTR;
typedef ATTR ALIST;

typedef struct descriptor_data DESC;

/* max length of command argument to process_command */
#define MAX_COMMAND_LEN 4096
#define BUFFER_LEN ((MAX_COMMAND_LEN)*2)

#ifdef CHAT_SYSTEM
/* Channel stuff */
typedef struct chanuser CHANUSER;
typedef struct chanlist CHANLIST;
typedef struct channel CHAN;
#endif


#endif
