/* Prefix-matched-key lookups. */

#ifndef PTAB_H
#define PTAB_H

struct ptab_entry;
typedef struct ptab {
  int state;
  int len;
  int maxlen;
  int current;
  struct ptab_entry **tab;
} PTAB;


void ptab_init(PTAB *);
void ptab_free(PTAB *);
void *ptab_find(PTAB *, const char *);
void *ptab_find_exact(PTAB *, const char *);
void ptab_delete(PTAB *, const char *);
void ptab_start_inserts(PTAB *);
void ptab_end_inserts(PTAB *);
void ptab_insert(PTAB *, const char *, void *);
void ptab_stats_header(dbref);
void ptab_stats(dbref, PTAB *, const char *);
void *ptab_firstentry(PTAB *);
void *ptab_nextentry(PTAB *);

#endif				/* PTAB_H */
