#ifndef _STRTREE_H_
#define _STRTREE_H_

/* Here we have the tree node structure.  Pretty basic
 * parentless binary tree.  info holds the red/black
 * property and the usage count.  This structure is
 * rarely fully allocated; instead, only enough is
 * allocated to hold the pointers, info, and the null
 * terminated string.
 */
typedef struct strnode StrNode;
struct strnode {
  StrNode *left;
  StrNode *right;
  unsigned char info;
  char string[BUFFER_LEN];
};

typedef struct strtree StrTree;
struct strtree {
  StrNode *root;
  Size_t count;
  Size_t mem;
};

void st_init(StrTree *root);
char const *st_insert(char const *s, StrTree *root);
char const *st_insert_perm(char const *s, StrTree *root);
char const *st_find(char const *s, StrTree *root);
void st_delete(char const *s, StrTree *root);
void st_print(StrTree *root);
void st_flush(StrTree *root);

extern long st_count;

#endif
