#include "config.h"
#include "conf.h"
#include "copyrite.h"

#ifdef I_STDLIB
#include <stdlib.h>
#endif

#ifdef I_STRING
#include <string.h>
#else
#include <strings.h>
#endif

#ifdef MEM_CHECK

#include "externs.h"
#include "dbdefs.h"
#include "memcheck.h"
#include "mymalloc.h"
#include "log.h"
#include "confmagic.h"

typedef struct mem_check MEM;

struct mem_check {
  int ref_count;
  MEM *next;
  char ref_name[BUFFER_LEN];
};

static MEM *my_check = NULL;

/*** WARNING! DO NOT USE strcasecoll IN THESE FUNCTIONS OR YOU'LL CREATE
 *** AN INFINITE LOOP. DANGER, WILL ROBINSON!
 ***/

void
add_check(ref)
    const char *ref;
{
  MEM *loop, *newcheck, *prev = NULL;
  Size_t reflen;
  int cmp;

  for (loop = my_check; loop; loop = loop->next) {
    cmp = strcasecmp(ref, loop->ref_name);
    if (cmp == 0) {
      loop->ref_count++;
      return;
    } else if (cmp < 0)
      break;
    prev = loop;
  }
  reflen = strlen(ref) + 1;
  newcheck = (MEM *) malloc(sizeof(MEM) - BUFFER_LEN + reflen);
  memcpy(newcheck->ref_name, ref, reflen);
  newcheck->ref_count = 1;
  newcheck->next = loop;
  if (prev)
    prev->next = newcheck;
  else
    my_check = newcheck;
  return;
}

void
del_check(ref)
    const char *ref;
{
  MEM *loop, *prev = NULL;
  int cmp;

  for (loop = my_check; loop; loop = loop->next) {
    cmp = strcasecmp(ref, loop->ref_name);
    if (cmp == 0) {
      loop->ref_count--;
      if (!loop->ref_count) {
	if (!prev)
	  my_check = loop->next;
	else
	  prev->next = loop->next;
	free(loop);
      }
      return;
    } else if (cmp < 0)
      break;
    prev = loop;
  }
  do_rawlog(LT_CHECK,
	    T("ERROR: Tried deleting a check that was never added! :%s\n"),
	    ref);
}

void
list_mem_check(player)
    dbref player;
{

  MEM *loop;

  for (loop = my_check; loop; loop = loop->next) {
    notify_format(player, "%s : %d", loop->ref_name, loop->ref_count);
  }
}

void
log_mem_check()
{

  MEM *loop;

  for (loop = my_check; loop; loop = loop->next) {
    do_rawlog(LT_CHECK, "%s : %d", loop->ref_name, loop->ref_count);
  }
}

#endif				/* MEM_CHECK */
