% Upgrading to PennMUSH 1.8.x

Introduction
============

This file explains how to upgrade to a new version of PennMUSH.

There are three basic upgrade situations:

1. You're running a stock ("vanilla") PennMUSH server of some version
  and you want to upgrade to a later version
2. You've hacked your server source code a little bit here and there
  (adding a flag, for example). Hacks to the \*local.c files don't
  count as hacks, as they're easy to handle.
3. You've hacked your server source code a lot.

There is also a list of upgrade "GOTCHAS" at the end of this file.
Please read them.

The PennMUSH developers actually only support situation 1, but we'll
give some useful tips for 2 and 3 here, too.

**DISCLAIMER**: It is very wise to always back up your current working
MUSH directories before you try an upgrade. You were warned.

Vanilla upgrade
==================

You have basically three choices here: upgrade with patch files, track
a git version control repository, or build a whole new distribution.

Upgrading with patch files
--------------------------

This is the easiest way to upgrade your source code if you're keeping
up with patches as they come out, or if you're upgrading patchlevels
within a release (e.g., within 1.8.0).

To upgrade with patch files, get all the patch files for higher
patchlevels than your current version. For example, if you're running
1.8.0p0 and the latest version is 1.8.0p4, you need patches 1-4.

Patchfiles can be downloaded via <https://download.pennmush.org/Source/>
and are usually named things like 1.8.0-patch02 (the patch from 1.8.0p1
to 1.8.0p2) or, in some cases, 1.7.6p16-1.8.0p0.patch (the patch from
1.7.6p16 to 1.8.0p0).

Each patch file contains instructions at the top explaining how to
apply it. **FOLLOW THESE!** Don't assume they're all the same. The
options to use with the patch program change, and sometimes further
steps are required.

After you've applied all the patches and followed all the
instructions, you should be good to go. In most cases, you can simply
`@shutdown/reboot` after the final successful compile. If
`@shutdown/reboot` crashes, you'll have to restart again.

Using git
---------

    % git clone https://github.com/pennmush/pennmush.git

To update from the master branch:

    % git pull

Each release is tagged; if you don't want to follow the latest
changest you can check out a specific one:

    % git checkout 186p1

Building a new distribution
---------------------------

When you're upgrading across release and no patchlevel is provided to
make the upgrade (e.g. from 1.7.4p3 to 1.8.0p0), it's often easier to
simply build a new distribution following the INSTALL instructions,
but with your old configuration stuff.

Up until 1.8.2p5, all PennMUSH installs unpacked into a directory
called pennmush/, so it was necessary to rename your existing
directory to something like oldpenn/ prior to unpacking the new
version. From 1.8.2p5 and onwards, directory names are
version-specific (pennmush-1.8.2p5/), so this is no longer necessary.

All of the steps below should be taken before running `./configure` for
the new version:

### options.h and game/*.cnf

You can copy the options.h file and game/mush.cnf file from your old
version to the new version. The `make update` command (run after
`configure`) will compare your files with the newly distributed ones
and tell you about options that have been added or removed. If you
have any options defined that the new version doesn't recognize,
you'll be asked if you want to retain them (which is safe).

If your mush.cnf file is called something else, copy it to mush.cnf in
pennmush/game anyway, since that's the file that gets updated. Then
make a link to that file called whatever.cnf if you want to use that.

If you've modified the restart script, you'll have to decide if your
modified script is still appropriate, or modify a copy of the
distributed game/restart script as you like it. it is highly
recommended that you copy restart to a second file, called something
like restart.local, and modify and use it instead of the stock restart
script to reduce conflicts when patching.

You can also copy your old game/access.cnf, game/names.cnf, and
game/txt/*.txt files into the appropriate locations. You may wish to
do the same thing for game/restrict.cnf and game/alias.cnf, but you
should compare them to the new versions, as restrictions and aliases
that may formerly have been compiled into the server may now be
specified in the .cnf files instead.

### src/*local.c

You should copy local.c, cmdlocal.c, and funlocal.c from oldpenn/src
to pennmush/src if you want to retain this local code. Of course, it
may not still work, but it's quite likely that it will. If you don't
have any such code, you can skip this step.

### Databases

If you are upgrading from 1.7.4 (or earlier) to 1.7.7 (or later),
you must first load your old database under PennMUSH 1.7.6 and
then dump it, and load this converted database under your
target version of PennMUSH. PennMUSH 1.7.7+ can no longer read
1.7.4 databases.

If you are upgrading from 1.7.6 or certain 1.7.7 versions,
you may also first need to load your database under PennMUSH
1.8.0p13 and then dump it, and load this converted database
under your target version of PennMUSH.

PennMUSH with a few hacks
=========================

When you have only a few local hacks outside of the src/*local.c
files, you can often patch up using the patch file method discussed
above. Alternatively, you can build a new version and reapply your
changes.

One small exception is upgrading from a version that used the old flag
system to one that uses the new flag system (post-1.7.7p5), if you've
added flags or toggles.  You probably had an #define in hdrs/flags.h
for your flag's bit value.  This now should be moved to
hdrs/oldflags.h; you should leave in the table entry in
src/flags.c. If you set up a macro for testing your flag in
hdrs/mushdb.h, you'll need to change it to use the `has_flag_by_name()`
function - see the many examples in that file.

If this isn't suitable (you're crossing releases or your hacks are too
many for this to work cleanly), see below.

PennMUSH with a lot of hacks
============================

If you've seriously hacked your server source code, you're on your own
in terms of keeping up with new patchlevels. Some people apply
patchfiles and fix the rejected hunks.

However, this should be easier to do with git. Just fork a copy of the
main repository and update from it as needed and deal with merge
conflicts through it.
